import PropTypes from "prop-types";
import { Link as RouterLink } from "react-router-dom";
// material
import { Box } from "@mui/material";
import useLanguage from "../hooks/useLanguage";
import useDeviceId from "../hooks/useDeviceId";

import React from "react";
// ----------------------------------------------------------------------

Logo.propTypes = {
  sx: PropTypes.object,
};

export default function Logo({ sx }) {
  const { mode } = useLanguage();
  const { setDeviceID } = useDeviceId();
  return (
    <RouterLink to="/" onClick={() => { setDeviceID(null) }}>
      <Box
        component="img"
        src={
          mode !== "Dark"
            ? "/static/logo_Black.svg"
            : "/static/logo_White.svg"
        }
        sx={{ width: 150, height: 40, ...sx }}
      />
    </RouterLink>
  );
}