import {
    Button,
    Box,
    Modal,
    Card,
    Checkbox,
    FormControlLabel,
    Grid,
  } from "@mui/material";
  import React, { useState } from "react";
  import TextField from "@mui/material/TextField";
  import DialogActions from "@mui/material/DialogActions";
  import DialogContent from "@mui/material/DialogContent";
  import DialogContentText from "@mui/material/DialogContentText";
  import DialogTitle from "@mui/material/DialogTitle";
  
  import axios from "axios";
  
  const PlanDilog = ({ open, handleClose, update, defaultData }) => {
    const [formData, setFormData] = useState(defaultData);
  
    const [isError, setError] = useState(false);
  
    const handleSubmit = async () => {
      try {
        if (
          !formData.title ||
          !formData.cost_price ||
          !formData.description
        ) {
          setError(true);
          return;
        }
  
        await axios.post(update?`admin/plan-update/${formData.id}`:`admin/plan-store`, formData);
  
        handleClose(true);
      } catch (error) {
        console.log(error);
        handleClose();
      }
    };
  
    return (
      <Modal
        open={open}
        onClose={handleClose}
        aria-labelledby="modal-modal-title"
        aria-describedby="modal-modal-description"
      >
        <Card sx={{ width: "50%", margin: "100px auto auto auto" }}>
          <Box
            className="FormLayout"
            sx={{
              width: "100%",
              margin: "auto",
            }}
          >
            <Box>
              <DialogTitle>{update?"Update Plan":"Create New Plan"}</DialogTitle>
  
              <DialogContent>
                {isError ? (
                  <DialogContentText color="red">
                    All Fields Must Be Field.
                  </DialogContentText>
                ) : null}
  
                <Grid container spacing={2}>
                  <Grid item xs={8}>
                    <TextField
                      fullWidth
                      autoFocus
                      margin="dense"
                      disabled={update}
                      id="title"
                      variant="outlined"
                      value={formData.title}
                      onChange={(e) =>
                        setFormData((data) => ({
                          ...data,
                          title: e.target.value,
                        }))
                      }
                      label="title"
                      type="text"
                    />
                  </Grid>
                  <Grid item xs={4}>
                    <TextField
                      fullWidth
                      margin="dense"
                      id="cost_price"
                      variant="outlined"
                      label="Price"
                      value={formData.cost_price}
                      onChange={(e) =>
                        setFormData((data) => ({
                          ...data,
                          cost_price: e.target.value,
                        }))
                      }
                      type="number"
                    />
                  </Grid>


                  <Grid item xs={12}>
                    <TextField
                      fullWidth
                      autoFocus
                      margin="dense"
                      multiline
                      id="description"
                      variant="outlined"
                      value={formData.description}
                      onChange={(e) =>
                        setFormData((data) => ({
                          ...data,
                          description: e.target.value,
                        }))
                      }
                      label="description"
                      type="text"
                    />
                  </Grid>
                  


                </Grid>
  
                <Box>
                  <FormControlLabel
                    control={
                      <Checkbox
                        size="large"
                        value={formData.status ? true : false}
                        defaultChecked={formData.status? true : false}
                        onChange={(e) =>
                          setFormData((data) => ({
                            ...data,
                            status: e.target.checked ? 1 : 0,
                          }))
                        }
                      />
                    }
                    label="status"
                  />
                </Box>
  
                <DialogActions>
                  <Button
                    onClick={() => {
                      handleClose();
                    }}
                  >
                    Cancel
                  </Button>
                  <Button onClick={handleSubmit}>{update?"update":"Add New"}</Button>
                </DialogActions>
              </DialogContent>
            </Box>
          </Box>
        </Card>
      </Modal>
    );
  };
  
  export default PlanDilog;
  