import PropTypes from "prop-types";
// material
import { Paper, Typography } from "@mui/material";

import useLanguage from "../hooks/useLanguage";
import React from "react";
// ----------------------------------------------------------------------

SearchNotFound.propTypes = {
  searchQuery: PropTypes.string,
};

export default function SearchNotFound({ searchQuery = "", ...other }) {
  const translate = useLanguage().translate;
  return (
    <Paper {...other}>
      <Typography gutterBottom align="center" variant="subtitle1">
        {translate("Not found")}
      </Typography>
      <Typography variant="body2" align="center">
        {translate("No results found for")} &nbsp;
        <strong>&quot;{searchQuery}&quot;</strong>.
        {translate("Try checking for typos or using complete words.")}
      </Typography>
    </Paper>
  );
}
