import axios from "axios";
import React, { useEffect, useState, createContext } from "react";

const authContext = createContext();

const useAuth = () => {
  const [authed, setAuthed] = useState(true);
  const [user, setUser] = useState({});
  const [reload, setReload] = useState(0);

  
  useEffect(async () => {
    if (localStorage.getItem("token")) {
      try {
        const result = await axios.get("me");
        const featuresResult = await axios.get(`admin/master-feature-view`);
        const featuresList = featuresResult.data.data.filter((item) => item.status);

        const user = result.data[0];
        const parmissions = user.permission.split(",").map((item) => Number(item));

        const allowedFeatures = featuresList.filter((item) => parmissions.includes(item.id))

        const finalParmissions = [];
        allowedFeatures.map((item) => {
          if (item.parent_id) {
            const avaiableParent = finalParmissions.filter((item2) => item2.id == Number(item.parent_id))[0];
            const parent_id = Number(item.parent_id);
            if (avaiableParent) {
              avaiableParent.children.push(item)
            } else {
              const parentFeature = featuresList.filter((item) => item.id == parent_id)[0];
              parentFeature.children = [item];
              finalParmissions.push(parentFeature);
            }
          } else {
            finalParmissions.push(item);
          }
        })

        user.allURLs = featuresList.map((item) => item.path);
        user.allowedURLs = allowedFeatures.map((item) => item.path);
        user.permission = finalParmissions;
        user.allowedFeaturesWithoutDevice = [{
          name: "My Devices",
          path: "/dashboard/user-devices",
          icon: "ic:round-phone-android",
          disactive: true
        },  {
          name: "add new Device",
          path: "/dashboard/add-new",
          icon: "ic:round-phone-android",
        },]

        console.log(user)
        setUser(user);
      } catch (error) {
        console.log(error)
        if (error.response.status === 401) {
          setAuthed(false);
          localStorage.clear();
        }
      }
    } else {
      setAuthed(false);
    }
  }, [reload]);

  return {
    authed,
    user,
    login: async (email, password, remind) => {
      try {
        const result = await axios.post("auth/login", {
          email,
          password,
        });
        if (remind) {
          //reminder Code
        }
        setReload((pri) => pri + 1);

        localStorage.setItem("token", result.data.data.token);

        setAuthed(true);
        return "Successful";
      } catch (error) {
        console.log(error)
        return error.response.data.message;
      }
    },
    logout: () => {
      try {
        setAuthed(false);

        localStorage.clear();
        return "Successful";
      } catch (error) {
        return error;
      }
    },
  };
};

export const AuthProvider = ({ children }) => {
  const auth = useAuth();
  return <authContext.Provider value={auth}>{children}</authContext.Provider>;
};

const AuthConsumer = () => {
  return React.useContext(authContext);
};
export default AuthConsumer;