import PropTypes from "prop-types";
import { useEffect } from "react";
import { Link as RouterLink, useLocation, useNavigate } from "react-router-dom";
// material
import { styled } from "@mui/material/styles";
import {
  Box,
  Link,
  Drawer,
  Typography,
  Avatar,
  FormControl,
  Select,
  MenuItem,
} from "@mui/material";
// hooks
import useResponsive from "../../hooks/useResponsive";
// components
import Logo from "../../components/Logo";
import Scrollbar from "../../components/Scrollbar";
import NavSection from "../../components/NavSection";
import useAuth from "../../hooks/useAuth";
import React from "react";

// ----------------------------------------------------------------------

import useDeviceId from "../../hooks/useDeviceId";

const DRAWER_WIDTH = 280;

const RootStyle = styled("div")(({ theme }) => ({
  [theme.breakpoints.up("lg")]: {
    flexShrink: 0,
    width: DRAWER_WIDTH,
  },
}));

const AccountStyle = styled("div")(({ theme }) => ({
  display: "flex",
  alignItems: "center",
  padding: theme.spacing(2, 2.5),
  borderRadius: Number(theme.shape.borderRadius) * 1.5,
  backgroundColor: theme.palette.grey[500_12],
}));

// ----------------------------------------------------------------------

DashboardSidebar.propTypes = {
  isOpenSidebar: PropTypes.bool,
  onCloseSidebar: PropTypes.func,
};

export default function DashboardSidebar({
  flow,
  isOpenSidebar,
  onCloseSidebar,
}) {
  const { pathname } = useLocation();
  const isDesktop = useResponsive("up", "lg");

  useEffect(() => {
    if (isOpenSidebar) {
      onCloseSidebar();
    }
  }, [pathname]);

  const renderContent = (
    <Scrollbar
      sx={{
        height: 1,
        "& .simplebar-content": {
          height: 1,
          display: "flex",
          flexDirection: "column",
        },
      }}
    >
      <Box sx={{ px: 2.5, py: 3, display: "block", width: "100%" }}>
        <Logo />
      </Box>
      <DevicesDropDown />

      <Box sx={{ flexGrow: 1 }} />

      <Box sx={{ px: 2.5, pb: 3, mt: 10 }}></Box>
    </Scrollbar>
  );
  return (
    <RootStyle>
      {!isDesktop && (
        <Drawer
          anchor={flow === "RTL" ? "right" : "left"}
          open={isOpenSidebar}
          onClose={onCloseSidebar}
          PaperProps={{
            sx: { width: DRAWER_WIDTH },
          }}
        >
          {renderContent}
        </Drawer>
      )}

      {isDesktop && (
        <Drawer
          open
          anchor={flow === "RTL" ? "right" : "left"}
          variant="persistent"
          PaperProps={{
            sx: {
              width: DRAWER_WIDTH,
              bgcolor: "background.default",
            },
          }}
        >
          {renderContent}
        </Drawer>
      )}
    </RootStyle>
  );
}


const DevicesDropDown = () => {
  const { deviceID, setDeviceID, deviceList } = useDeviceId();
  const Navigate = useNavigate();
  const location = useLocation();

  const { user } = useAuth();


  
  const list = deviceList.filter((item) => {
    return item.device_status !== "inactive";
  });
  
  return (
    <>
      {deviceID ? (
        <FormControl sx={{ width: "250px", margin: "auto", mb: 5, mx: 2.5 }}>
          <Select
            id="demo-simple-select"
            value={deviceID}
            onChange={(e) => {

              let path = location.pathname;

              const lastIndex = path.lastIndexOf('/');
              path = path.slice(11, lastIndex);

              Navigate(path + "/" + e.target.value)
            }
            }
          >
            {list.map((item) => {
              return (
                <MenuItem key={item.id} value={item.id}>
                  {item.android_os} ({item.child_name})
                </MenuItem>
              );
            })}
          </Select>
        </FormControl>
      ) : (<Box sx={{ mb: 5, mx: 2.5 }}>
        <AccountStyle>
          <Avatar
            src="/static/mock-images/avatars/avatar_default.jpg"
            alt="photoURL"
          />
          <Box sx={{ ml: 2 }}>
            <Typography variant="subtitle2" sx={{ color: "text.primary" }}>
              {user.name}
            </Typography>
          </Box>
        </AccountStyle>


      </Box>)}

      {user &&  user.user_type === "USER" ?
        deviceID ?
             <NavSection navConfig={user.permission ? user.permission : []} /> :
             <NavSection navConfig={user.allowedFeaturesWithoutDevice ? user.allowedFeaturesWithoutDevice : []} /> :
              <NavSection navConfig={user.permission ? user.permission : []} />}

    </>
  );
};
