import { useRef, useState } from 'react';
// material
import { alpha } from '@mui/material/styles';
import {
  Box,
  MenuItem,
  ListItemIcon,
  ListItemText,
  IconButton,
} from '@mui/material';
// components
import MenuPopover from '../../components/MenuPopover';
import useLanguage from '../../hooks/useLanguage';
import React from 'react';

// ----------------------------------------------------------------------

const LANGS = [
  {
    value: 'en',
    label: 'English',
    icon: '/static/icons/ic_flag_en.svg',
    flow: 'LTR',
  },
  {
    value: 'fr',
    label: 'French',
    icon: '/static/icons/ic_flag_de.svg',
    flow: 'LTR',
  },
  {
    value: 'arb',
    label: 'عربى',
    icon: '/static/icons/uae.svg',
    flow: 'RTL',
  },
];

// ----------------------------------------------------------------------

export default function LanguagePopover() {
  const anchorRef = useRef(null);
  const [open, setOpen] = useState(false);
  const { language, setLanguage } = useLanguage();

  const handleOpen = () => {
    setOpen(true);
  };

  const handleClose = (value) => {
    setOpen(false);

    if (value) {
      setLanguage({ value: value.value, flow: value.flow });
    }
  };

  const iconAndLable = (() => {
    let iconLable;
    LANGS.map((item) => {
      if (item.value === language.value) {
        iconLable = { icon: item.icon, lable: item.label };
      }
    });
    return iconLable;
  })();

  return (
    <>
      <IconButton
        ref={anchorRef}
        onClick={handleOpen}
        sx={{
          padding: 0,
          width: 44,
          height: 44,
          ...(open && {
            bgcolor: (theme) =>
              alpha(
                theme.palette.primary.main,
                theme.palette.action.focusOpacity
              ),
          }),
        }}
      >
        <img src={iconAndLable.icon} alt={iconAndLable.lable} />
      </IconButton>

      <MenuPopover
        open={open}
        onClose={() => {
          handleClose();
        }}
        anchorEl={anchorRef.current}
      >
        <Box sx={{ py: 1 }}>
          {LANGS.map((option) => (
            <MenuItem
              key={option.value}
              selected={option.value === language.value}
              onClick={() => handleClose(option)}
              sx={{ py: 1, px: 2.5 }}
            >
              <ListItemIcon>
                <Box component='img' alt={option.label} src={option.icon} />
              </ListItemIcon>
              <ListItemText primaryTypographyProps={{ variant: 'body2' }}>
                {option.label}
              </ListItemText>
            </MenuItem>
          ))}
        </Box>
      </MenuPopover>
    </>
  );
}
