// component
import Iconify from "src/components/Iconify";

// ----------------------------------------------------------------------

const getIcon = (name) => <Iconify icon={name} width={22} height={22} />;

const sidebarDashboard = [
  {
    id: 1,
    title: "My Devices",
    path: "/dashboard/user-devices",
    icon: getIcon("ic:round-phone-android"),
  },
  {
    id: 2,
    title: "Dashboard",
    path: "/dashboard/spy-app",
    icon: getIcon("eva:pie-chart-2-fill"),
  },
  {
    id: 3,
    title: "users",
    path: "/dashboard/users",
    icon: getIcon("ph:users-four-bold"),
  },
  {
    id: 4,
    title: "coupons",
    path: "/dashboard/coupons",
    icon: getIcon("fa-tags"),
  },
  {
    id: 5,
    title: "Device permissions",
    path: "/dashboard/device_permission",
    icon: getIcon("material-symbols:security"),
  },
  {
    id: 6,
    title: "Plans",
    path: "/dashboard/plans_admin",
    icon: getIcon("material-symbols:book-sharp"),
  },
  {
    id: 7,
    title: "Roles",
    path: "/dashboard/rols_admin",
    icon: getIcon("carbon:user-role"),
  },

  {
    id: 49,
    title: 'Features',
    path: '/dashboard/features_admin',
    icon: getIcon('material-symbols:format-list-bulleted'),
  },
  {
    id: 8,
    icon: getIcon("majesticons:chats-2"),
    title: "Messages",
    children: [
      {
        id: 32,
        path: "/dashboard/sms",
        icon: getIcon("ic:round-sms"),
        title: "SMS",
      },
      {
        id: 33,
        title: "WhatsApp Messages",
        path: "/dashboard/whatsapp_sms",
        icon: getIcon("fa-brands:whatsapp"),
      },
      {
        id: 34,
        title: "Snapchat Messages",
        path: "/dashboard/Snapchat_sms",
        icon: getIcon("fa-brands:snapchat"),
      },
      {
        id: 35,
        title: "Viber Messages",
        path: "/dashboard/Viber_sms",
        icon: getIcon("fa-brands:viber"),
      },
      {
        id: 36,
        title: "Telegram Messages",
        path: "/dashboard/Telegram_sms",
        icon: getIcon("fa-brands:telegram"),
      },
      {
        id: 37,
        title: "KiK Messages",
        path: "/dashboard/Kik_sms",
        icon: getIcon("simple-icons:kik"),
      },
      {
        id: 38,
        title: "Line Messages",
        path: "/dashboard/Line_sms",
        icon: getIcon("fa-brands:line"),
      },
      {
        id: 39,
        title: "imo Messages",
        path: "/dashboard/Imo_sms",
        icon: getIcon("simple-icons:imou"),
      },
      {
        id: 40,
        title: "Tinder Messages",
        path: "/dashboard/Tinder_sms",
        icon: getIcon("cib:tinder"),
      },
      {
        id: 41,
        title: "Facebook Messages",
        path: "/dashboard/facebook_sms",
        icon: getIcon("fa-brands:facebook"),
      },
      {
        id: 42,
        title: "Instagram Messages",
        path: "/dashboard/instagram_sms",
        icon: getIcon("akar-icons:instagram-fill"),
      },
    ],
  },
  {
    id: 9,
    title: "Locations",
    icon: getIcon("bxs:map"),
    children: [
      {
        id: 45,
        title: "Locations",
        path: "/dashboard/user-location",
        icon: getIcon("bxs:map"),
      },
      {
        id: 46,
        title: "Current Location",
        path: "/dashboard/Current-Location",
        icon: getIcon("carbon:location-person-filled"),
      },
      {
        id: 47,
        title: "Geo Tracking",
        path: "/dashboard/geo-tracking",
        icon: getIcon("carbon:map"),
      },
      {
        id: 48,
        title: "Geo Fencing",
        path: "/dashboard/geo-fencing",
        icon: getIcon("carbon:map-center"),
      },
    ],
  },
  {
    id: 10,
    title: "Calls",
    path: "/dashboard/calls-list",
    icon: getIcon("eva:phone-fill"),
  },
  {
    id: 11,
    title: "Wifi Logger",
    path: "/dashboard/wifi",
    icon: getIcon("eva:wifi-fill"),
  },
  {
    id: 12,
    title: "Browser History",
    path: "/dashboard/web-history",
    icon: getIcon("eva:browser-fill"),
  },
  {
    id: 13,
    title: "Youtube Details",
    path: "/dashboard/youtube-details",
    icon: getIcon("entypo-social:youtube"),
  },
  {
    id: 14,
    title: "Keyword Alart",
    path: "/dashboard/Keyword-Aleart",
    icon: getIcon("ant-design:alert-filled"),
  },
  {
    id: 15,
    title: "Call Recordings",
    path: "/dashboard/calls-recordings",
    icon: getIcon("ion:recording-sharp"),
  },
  {
    id: 16,
    title: "Application Activitys",
    path: "/dashboard/apps-activities",
    icon: getIcon("bxs:bar-chart-alt-2"),
  },
  {
    id: 17,
    title: "Gmail",
    path: "/dashboard/gmails",
    icon: getIcon("bxl:gmail"),
  },
  {
    id: 18,
    title: "Images",
    path: "/dashboard/images",
    icon: getIcon("entypo:images"),
  },
  {
    id: 19,
    title: "Capture Screenshot",
    path: "/dashboard/screenshot-capture",
    icon: getIcon("ic:outline-screenshot"),
  },
  {
    id: 20,
    title: "Take Picture",
    path: "/dashboard/take-pictures",
    icon: getIcon("ant-design:camera-twotone"),
  },
  {
    id: 21,
    title: "Videos",
    path: "/dashboard/videos",
    icon: getIcon("clarity:video-gallery-solid"),
  },
  {
    id: 22,
    title: "Screen Recording",
    path: "/dashboard/screen-recording",
    icon: getIcon("cil:screen-smartphone"),
  },
  {
    id: 23,
    title: "Video Recording",
    path: "/dashboard/video-recording",
    icon: getIcon("bx:video-recording"),
  },
  {
    id: 24,
    title: "Audio Recording",
    path: "/dashboard/audio-record",
    icon: getIcon("uis:record-audio"),
  },
  {
    id: 25,
    title: "Voices",
    path: "/dashboard/voices",
    icon: getIcon("ic:baseline-audio-file"),
  },
  {
    id: 26,
    title: "Calender Events",
    path: "/dashboard/calender-events",
    icon: getIcon("simple-line-icons:calender"),
  },
  {
    id: 27,
    title: "App Block",
    path: "/dashboard/app-block",
    icon: getIcon("mdi:cancel"),
  },
  {
    id: 28,
    title: "Website Block",
    path: "/dashboard/web-block",
    icon: getIcon("mdi:cancel"),
  },
  {
    id: 29,
    title: "Contacts",
    path: "/dashboard/user-contacts",
    icon: getIcon("eva:people-fill"),
  },
  {
    id: 30,
    title: "Settings",
    path: "/dashboard/settings",
    icon: getIcon("carbon:settings"),
  },
  {
    id: 31,
    title: "add new Decive",
    path: "/dashboard/add-new",
    icon: getIcon("ic:round-phone-android"),
  },
];

export { sidebarDashboard };
