import { useEffect, useMemo, useState } from 'react';
import { Outlet } from 'react-router-dom';
// material
import { styled } from '@mui/material/styles';
//
import DashboardNavbar from './DashboardNavbar';
import DashboardSidebar from './DashboardSidebar';
import useLanguage from '../../hooks/useLanguage';

// ----------------------------------------------------------------------

const APP_BAR_MOBILE = 64;
const APP_BAR_DESKTOP = 92;

const RootStyle = styled('div')({
  display: 'flex',
  minHeight: '100%',
  overflow: 'hidden',
});

const MainStyle = styled('div')(({ theme }) => ({
  flexGrow: 1,
  overflow: 'auto',
  minHeight: '100%',
  paddingTop: APP_BAR_MOBILE + 24,
  paddingBottom: theme.spacing(10),
  [theme.breakpoints.up('lg')]: {
    paddingTop: APP_BAR_DESKTOP + 24,
    paddingLeft: theme.spacing(2),
    paddingRight: theme.spacing(2),
  },
}));

// ----------------------------------------------------------------------

export default function DashboardLayout() {
  const [open, setOpen] = useState(false);

  const { language, mode, setMode } = useLanguage();

  return (
    <RootStyle>
      {language.flow === 'RTL' ? (
        <>
          <DashboardNavbar
            mode={mode}
            setMode={setMode}
            flow={language.flow}
            onOpenSidebar={() => setOpen(true)}
          />
          <MainStyle>
            <Outlet />
          </MainStyle>

          <DashboardSidebar
            flow={language.flow}
            isOpenSidebar={open}
            onCloseSidebar={() => setOpen(false)}
          />
        </>
      ) : (
        <>
          <DashboardNavbar
            mode={mode}
            setMode={setMode}
            flow={language.flow}
            onOpenSidebar={() => setOpen(true)}
          />
          <DashboardSidebar
            flow={language.flow}
            isOpenSidebar={open}
            onCloseSidebar={() => setOpen(false)}
          />
          <MainStyle>
            <Outlet />
          </MainStyle>
        </>
      )}
    </RootStyle>
  );
}
