import React from 'react';
import { useEffect, useState } from 'react';
// material
import {
  Card,
  FormGroup,
  FormControlLabel,
  Switch,
  Button,
  Table,
  Stack,
  Avatar,
  Checkbox,
  TableRow,
  TableBody,
  TableCell,
  Container,
  Typography,
  TableContainer,
} from '@mui/material';
// components
import Page from '../components/Page';
import Scrollbar from '../components/Scrollbar';
import SearchNotFound from '../components/SearchNotFound';
import {
  UcListHead,
  UcListToolbar,
  UcMoreMenu,
} from '../sections/@dashboard/utilityComponents';
//
import axios from 'axios';
import useDeviceId from '../hooks/useDeviceId';
// ----------------------------------------------------------------------

const TABLE_HEAD = [

  { id: 'id', label: 'ID', alignRight: false },
  { id: 'application_name', label: 'NAME', alignRight: false },
  { id: 'application_package_name', label: 'PACKAGE NAME', alignRight: false },
  { id: 'status', label: 'BLOCK/UNBLOCK', alignRight: false },
];

import useLanguage from '../hooks/useLanguage';
import MyTablePagination from 'src/sections/@dashboard/utilityComponents/MyTablePagination';
import AlignedTableCell from 'src/sections/@dashboard/utilityComponents/AlignedTableCell';

// ----------------------------------------------------------------------

function descendingComparator(a, b, orderBy) {
  if (b[orderBy] < a[orderBy]) {
    return -1;
  }
  if (b[orderBy] > a[orderBy]) {
    return 1;
  }
  return 0;
}

function getComparator(order, orderBy) {
  return order === 'desc'
    ? (a, b) => descendingComparator(a, b, orderBy)
    : (a, b) => -descendingComparator(a, b, orderBy);
}

function applySortFilter(array, comparator, query) {
  const stabilizedThis = array.map((el, index) => [el, index]);
  stabilizedThis.sort((a, b) => {
    const order = comparator(a[0], b[0]);
    if (order !== 0) return order;
    return a[1] - b[1];
  });

  return stabilizedThis.map((el) => el[0]);
}

export default function AppBlock() {
  const [page, setPage] = useState(0);
  const [order, setOrder] = useState('asc');
  const [selected, setSelected] = useState([]);
  const [orderBy, setOrderBy] = useState('name');
  const [filter, setFilter] = useState('');
  const [total_count,setTotal_Count] = useState(0);
  const [rowsPerPage, setRowsPerPage] = useState(5);
  const { deviceID } = useDeviceId();
  const translate = useLanguage().translate;
  const [APPBLOCKLIST, setAPPBLOCKLIST] = useState([]);
  const [reload,setReload] = useState(0);



  useEffect(async () => {
    try {
      const result = await axios.get(`appblock/${deviceID}`, {
        params: {
          page: page + 1,
          limit: rowsPerPage,
          search: filter,
        },
      });
      setTotal_Count(result.data.data.total_count);
      setAPPBLOCKLIST(result.data.data.application_data);
    } catch (error) {
      console.log(error);
    }
  }, [page, rowsPerPage, deviceID, filter,reload]);

  const handleRequestSort = (event, property) => {
    const isAsc = orderBy === property && order === 'asc';
    setOrder(isAsc ? 'desc' : 'asc');
    setOrderBy(property);
  };

  const handleSelectAllClick = (event) => {
    if (event.target.checked) {
      const newSelecteds = APPBLOCKLIST.map((n) => n.id);
      setSelected(newSelecteds);
      return;
    }
    setSelected([]);
  };


  const handleFilterByName = (value) => {
    setFilter(value);
  };

  const emptyRows =
    page > 0 ? Math.max(0, (1 + page) * rowsPerPage - APPBLOCKLIST.length) : 0;

  const filteredAppBlock = applySortFilter(
    APPBLOCKLIST,
    getComparator(order, orderBy),
    filter
  );

  const isAppBlockNotFound = filteredAppBlock.length === 0;

  //SortAllFuntionsForToolbar
  const sortAll = () => {
    let sortId = TABLE_HEAD[1].id;
    const isAsc = orderBy === sortId && order === 'asc';
    setOrder(isAsc ? 'desc' : 'asc');
    setOrderBy(sortId);
  };

  const handleCheckedChange = ({ id, checked }) => {
    //hare
    
    setReload((pri)=>pri+1)
  };

  return (
    <Page title={translate('App Block')}>
      <Container>
        <Stack
          direction='row'
          alignItems='center'
          justifyContent='space-between'
          mb={5}
        >
          <Typography variant='h4' gutterBottom>
            {translate('App Block')}
          </Typography>
        </Stack>

        <Card>
          <UcListToolbar
            onSort={sortAll}
            placeholder='Search By Name...'
            numSelected={selected.length}
            onFilter={handleFilterByName}
          />

          <Scrollbar>
            <TableContainer sx={{ minWidth: 800 }}>
              <Table>
                <UcListHead
                  order={order}
                  orderBy={orderBy}
                  headLabel={TABLE_HEAD}
                  rowCount={APPBLOCKLIST.length}
                  numSelected={selected.length}
                  onRequestSort={handleRequestSort}
                  onSelectAllClick={handleSelectAllClick}
                />
                <TableBody>
                  {filteredAppBlock.map((row) => {
                    const {
                      id,
                      application_name,
                      application_package_name,
                      status,
                      application_logo,
                    } = row;
                    const isItemSelected = selected.indexOf(id) !== -1;

                    return (
                      <TableRow
                        hover
                        key={id}
                        tabIndex={-1}
                        role='checkbox'
                        selected={isItemSelected}
                        aria-checked={isItemSelected}
                      >
                        <AlignedTableCell flow='left'>
                          {id}
                        </AlignedTableCell>
                        
                        <TableCell component='th' scope='row' padding='normal'>
                          <Stack
                            direction='row'
                            alignItems='center'
                            spacing={2}
                          >
                            <Avatar
                              alt={application_name}
                              src={application_logo}
                            />
                            <Typography variant='subtitle2' noWrap>
                              {application_name}
                            </Typography>
                          </Stack>
                        </TableCell>
                        <AlignedTableCell flow='left'>
                          {application_package_name}
                        </AlignedTableCell>
                        <AlignedTableCell flow='left'>
                          <FormGroup>
                            <FormControlLabel
                              control={
                                <Switch
                                  defaultChecked={!!status}
                                  onChange={(e) =>
                                    handleCheckedChange({
                                      id: id,
                                      checked: e.target.checked,
                                    })
                                  }
                                />
                              }
                              label={status ? <>Block</> : <>unblock</>}
                            />
                          </FormGroup>
                        </AlignedTableCell>

                      </TableRow>
                    );
                  })}
                  {emptyRows > 0 && (
                    <TableRow style={{ height: 53 * emptyRows }}>
                      <TableCell colSpan={6} />
                    </TableRow>
                  )}
                </TableBody>
                {isAppBlockNotFound && (
                  <TableBody>
                    <TableRow>
                      <TableCell align='center' colSpan={6} sx={{ py: 3 }}>
                        <SearchNotFound searchQuery={filter} />
                      </TableCell>
                    </TableRow>
                  </TableBody>
                )}
              </Table>
            </TableContainer>
          </Scrollbar>

          <MyTablePagination
            count={total_count}
            rowsPerPage={rowsPerPage}
            page={page}
            setPage={setPage}
            setRowsPerPage={setRowsPerPage}
          />
        </Card>
      </Container>
    </Page>
  );
}
