import {
  Card,
  Container,
  Stack,
  Table,
  TableBody,
  TableCell,
  TableContainer,
  TableRow,
  Typography,
} from '@mui/material';
import axios from 'axios';
import React, { useEffect, useState } from 'react';
import Iconify from 'src/components/Iconify';
import Page from 'src/components/Page';
import Scrollbar from 'src/components/Scrollbar';
import SearchNotFound from 'src/components/SearchNotFound';
import {
  UcListHead,
  UcListToolbar,
  UcMoreMenu,
} from 'src/sections/@dashboard/utilityComponents';
import useDeviceId from '../hooks/useDeviceId';

import useLanguage from '../hooks/useLanguage';

import AudioPlayer from '../components/CustomAudioPlayer/AudioPlayer';
import MyTablePagination from 'src/sections/@dashboard/utilityComponents/MyTablePagination';
import AlignedTableCell from 'src/sections/@dashboard/utilityComponents/AlignedTableCell';
import MuiIcon from 'src/sections/@dashboard/utilityComponents/MuiIcon';

const TABLE_HEAD = [

  { id: 'id', label: 'ID', alignRight: false },
  { id: 'number', label: 'PHONE NUMBER', alignRight: false },
  { id: 'duration', label: 'DURATION', alignRight: false },
  { id: 'time', label: 'DATE & TIME', alignRight: false },
  { id: 'file', label: 'FILE', alignRight: false },
];

const CallRecordingsPage = () => {
  const [page, setPage] = useState(0);
  const [order, setOrder] = useState('asc');
  const [selected, setSelected] = useState([]);
  const [filter, setFilter] = useState('');
  const [orderBy, setOrderBy] = useState('name');
  const [rowsPerPage, setRowsPerPage] = useState(5);
  const [recordingsList, setCallRecordingList] = useState([]);
  const [totalrows, settotalrows] = useState(0);
  const [runingSong, setRuningSong] = useState('');
  const { deviceID, setDeviceID } = useDeviceId();
  const translate = useLanguage().translate;

  useEffect(async () => {
    try {
      const result = await axios.get(`call-recordings/${deviceID}`, {
        params: {
          page: page + 1,
          limit: rowsPerPage,
          search: filter,
        },
      });
      console.log(result);

      setCallRecordingList(result.data.data.callrecording_data);
      settotalrows(result.data.data.total_count);
    } catch (error) {
      console.log(error);
    }
  }, [page, rowsPerPage, filter, deviceID]);

  const handleClick = (event, id) => {
    const selectedIndex = selected.indexOf(id);
    let newSelected = [];
    if (selectedIndex === -1) {
      newSelected = newSelected.concat(selected, id);
    } else if (selectedIndex === 0) {
      newSelected = newSelected.concat(selected.slice(1));
    } else if (selectedIndex === selected.length - 1) {
      newSelected = newSelected.concat(selected.slice(0, -1));
    } else if (selectedIndex > 0) {
      newSelected = newSelected.concat(
        selected.slice(0, selectedIndex),
        selected.slice(selectedIndex + 1)
      );
    }
    setSelected(newSelected);
  };
  const filterList = (value) => {
    setPage(0);
    setFilter(value);
  };

  const filterFilesList = applySortFilter(
    recordingsList,
    getComparator(order, orderBy),
    filter
  );
  function applySortFilter(array, comparator, query) {
    const stabilizedThis = array.map((el, index) => [el, index]);
    stabilizedThis.sort((a, b) => {
      const order = comparator(a[0], b[0]);
      if (order !== 0) return order;
      return a[1] - b[1];
    });

    return stabilizedThis.map((el) => el[0]);
  }

  function getComparator(order, orderBy) {
    return order === 'desc'
      ? (a, b) => descendingComparator(a, b, orderBy)
      : (a, b) => -descendingComparator(a, b, orderBy);
  }

  function descendingComparator(a, b, orderBy) {
    if (b[orderBy] < a[orderBy]) {
      return -1;
    }
    if (b[orderBy] > a[orderBy]) {
      return 1;
    }
    return 0;
  }

  //SortAllFuntionsForToolbar
  const sortAll = () => {
    let sortId = TABLE_HEAD[1].id;
    const isAsc = orderBy === sortId && order === 'asc';
    setOrder(isAsc ? 'desc' : 'asc');
    setOrderBy(sortId);
  };

  const handleSelectAllClick = (event) => {
    if (event.target.checked) {
      const newSelecteds = recordingsList.map((n) => n.id);
      setSelected(newSelecteds);
      return;
    }
    setSelected([]);
  };

  const handleRequestSort = (event, property) => {
    const isAsc = orderBy === property && order === 'asc';
    setOrder(isAsc ? 'desc' : 'asc');
    setOrderBy(property);
  };

  const isUserNotFound = recordingsList.length === 0;
  return (
    <Page title={translate('Call Recordings')}>
      <Container>
        <Stack
          direction='row'
          alignItems='center'
          justifyContent='space-between'
          mb={5}
        >
          <Typography variant='h4' gutterBottom>
            {translate('Call Recordings')}
          </Typography>
        </Stack>

        <Card>
          <UcListToolbar
            onSort={sortAll}
            placeholder='Search By Number...'
            numSelected={selected.length}
            onFilter={filterList}
          />
          <Scrollbar>
            <TableContainer sx={{ minWidth: 800 }}>
              <Table>
                <UcListHead
                  order={order}
                  orderBy={orderBy}
                  headLabel={TABLE_HEAD}
                  rowCount={recordingsList.length}
                  numSelected={selected.length}
                  onRequestSort={handleRequestSort}
                  onSelectAllClick={handleSelectAllClick}
                />
                <TableBody>
                  {filterFilesList.map((row) => {
                    const { id, number, duration, src, time } = row;
                    const isItemSelected = selected.indexOf(id) !== -1;

                    return (
                      <TableRow
                        hover
                        key={id}
                        tabIndex={-1}
                        role='checkbox'
                        selected={isItemSelected}
                        aria-checked={isItemSelected}
                      >
                        
                            <AlignedTableCell flow='left'>
                              {id}
                        </AlignedTableCell>
                        
                        <AlignedTableCell flow='left'>
                        <MuiIcon icon='eva:people-fill' />
                              {number}
                        </AlignedTableCell>
                        
                        <AlignedTableCell flow='left'>
                          <Iconify icon='eva:clock-fill' />
                          {duration}
                        </AlignedTableCell>
                        <AlignedTableCell flow='left'>{time}</AlignedTableCell>
                        <AlignedTableCell flow='right'>
                          <AudioPlayer
                            item={row}
                            setRuningSong={setRuningSong}
                            runingSong={runingSong}
                          />
                        </AlignedTableCell>
                        </TableRow>
                    );
                  })}
                </TableBody>
                {isUserNotFound && (
                  <TableBody>
                    <TableRow>
                      <TableCell align='center' colSpan={6} sx={{ py: 3 }}>
                        <SearchNotFound searchQuery={filter} />
                      </TableCell>
                    </TableRow>
                  </TableBody>
                )}
              </Table>
            </TableContainer>
          </Scrollbar>

          <MyTablePagination
            count={totalrows}
            rowsPerPage={rowsPerPage}
            page={page}
            setPage={setPage}
            setRowsPerPage={setRowsPerPage}
          />
        </Card>
      </Container>
    </Page>
  );
};

export default CallRecordingsPage;
