import React from 'react';
import { useEffect, useState } from 'react';
// material
import {
  Card,
  Table,
  Stack,
  TableRow,
  TableBody,
  TableCell,
  Container,
  Typography,
  TableContainer,
  IconButton,
} from '@mui/material';
// components
import Page from '../components/Page';
import Scrollbar from '../components/Scrollbar';
import SearchNotFound from '../components/SearchNotFound';
import Iconify from '../components/Iconify';
import {
  UcListHead,
  UcListToolbar,
  UcMoreMenu,
} from '../sections/@dashboard/utilityComponents';
//

import useDeviceId from '../hooks/useDeviceId';
import axios from 'axios';

import useLanguage from '../hooks/useLanguage';
import MyTablePagination from 'src/sections/@dashboard/utilityComponents/MyTablePagination';
import AlignedTableCell from 'src/sections/@dashboard/utilityComponents/AlignedTableCell';
import MuiIcon from 'src/sections/@dashboard/utilityComponents/MuiIcon';
// ----------------------------------------------------------------------

const TABLE_HEAD = [
  { id: 'id', label: 'ID', alignRight: false },
  { id: 'cont_name', label: 'NAME', alignRight: false },
  { id: 'phone_number', label: 'PHONE NUMBER', alignRight: false },
  { id: 'type', label: 'TYPE', alignRight: false },
  { id: 'duration', label: 'DURATION', alignRight: false },
  { id: 'date_time', label: 'DATE & TIME', alignRight: true },
];

// ----------------------------------------------------------------------
export default function Calls() {
  const [order, setOrder] = useState('asc');
  const [selected, setSelected] = useState([]);
  const [orderBy, setOrderBy] = useState('cont_name');
  const [filter, setFilter] = useState('');
  const [totalrows, settotalrows] = useState(0);
  const [callsList, setCallsList] = useState([]);

  const [page, setPage] = useState(0);
  const [rowsPerPage, setRowsPerPage] = useState(5);
  const { deviceID, setDeviceID } = useDeviceId();
  const translate = useLanguage().translate;

  const isUserNotFound = callsList.length === 0;

  useEffect(async () => {
    try {
      const result = await axios.get(`calls/${deviceID}`, {
        params: {
          page: page + 1,
          limit: rowsPerPage,
          search: filter,
        },
      });
      

      console.log(result);
      setCallsList(result.data.data.callLog_data);
      settotalrows(result.data.data.total_count);
    } catch (error) {
      console.log(error);
    }
  }, [page, rowsPerPage, deviceID, filter]);

  const handleSelectAllClick = (event) => {
    if (event.target.checked) {
      const newSelecteds = callsList.map((n) => n.id);
      setSelected(newSelecteds);
      return;
    }
    setSelected([]);
  };

  const reload = async () => {
    try {
      const result = await axios.get(`notifications/${deviceID}`, {
        params: {
          notification: "CALL_LOGS",
        },
      });
      console.log(result);
    } catch (error) {
      console.log(error);
    }
  };

  const handleFilter = (value) => {
    setPage(0);
    setFilter(value);
  };
  //-----------------------------------------------------

  //SortAllFuntionsForToolbar
  const sortAll = () => {
    let sortId = TABLE_HEAD[1].id;
    const isAsc = orderBy === sortId && order === 'asc';
    setOrder(isAsc ? 'desc' : 'asc');
    setOrderBy(sortId);
  };

  const handleRequestSort = (event, property) => {
    const isAsc = orderBy === property && order === 'asc';
    setOrder(isAsc ? 'desc' : 'asc');
    setOrderBy(property);
  };

  const filteredCallsList = applySortFilter(
    callsList,
    getComparator(order, orderBy),
    filter
  );

  function applySortFilter(array, comparator, query) {
    const stabilizedThis = array.map((el, index) => [el, index]);
    stabilizedThis.sort((a, b) => {
      const order = comparator(a[0], b[0]);
      if (order !== 0) return order;
      return a[1] - b[1];
    });

    return stabilizedThis.map((el) => el[0]);
  }

  function getComparator(order, orderBy) {
    return order === 'desc'
      ? (a, b) => descendingComparator(a, b, orderBy)
      : (a, b) => -descendingComparator(a, b, orderBy);
  }

  function descendingComparator(a, b, orderBy) {
    if (b[orderBy] < a[orderBy]) {
      return -1;
    }
    if (b[orderBy] > a[orderBy]) {
      return 1;
    }
    return 0;
  }
  return (
    <Page title={translate('Calls')}>
      <Container>
        <Stack
          direction='row'
          alignItems='center'
          justifyContent='space-between'
          mb={5}
        >
          <Typography variant='h4' gutterBottom>
            {translate('Calls')}
            <IconButton onClick={reload} >
              <MuiIcon icon="pepicons:reload" width="25px" height="25px" />
            </IconButton>
          </Typography>
        </Stack>

        <Card>
          <UcListToolbar
            onSort={sortAll}
            placeholder='Search...'
            numSelected={selected.length}
            onFilter={handleFilter}
          />

          <Scrollbar>
            <TableContainer sx={{ minWidth: 800 }}>
              <Table>
                <UcListHead
                  order={order}
                  orderBy={orderBy}
                  headLabel={TABLE_HEAD}
                  rowCount={callsList.length}
                  numSelected={selected.length}
                  onRequestSort={handleRequestSort}
                  onSelectAllClick={handleSelectAllClick}
                />
                <TableBody>
                  {filteredCallsList.map((row) => {
                    const {
                      id,
                      cont_name,
                      number,
                      type,
                      duration,
                      date_time
                    } = row;
                    const isItemSelected = selected.indexOf(id) !== -1;

                    return (
                      <TableRow
                        hover
                        key={id}
                        tabIndex={-1}
                        role='checkbox'
                        selected={isItemSelected}
                        aria-checked={isItemSelected}
                      >
                        <AlignedTableCell flow='left'>
                          {id}
                        </AlignedTableCell>
                        <TableCell component='th' scope='row' padding='normal'>
                          <Stack
                            direction='row'
                            alignItems='center'
                            spacing={2}
                          >
                            <Typography variant='subtitle2' noWrap>
                              <MuiIcon icon='eva:people-fill' />
                              {cont_name}
                            </Typography>
                          </Stack>
                        </TableCell>

                        <AlignedTableCell flow='left'>
                          {number}
                        </AlignedTableCell>
                        <AlignedTableCell flow='left'>
                          <MuiIcon icon='eva:phone-fill' />
                          {type}
                        </AlignedTableCell>
                        <AlignedTableCell flow='left'>
                          <MuiIcon icon='eva:clock-fill' />
                          {duration}
                        </AlignedTableCell>
                        <AlignedTableCell flow='right'>
                          {date_time}
                        </AlignedTableCell>
                      </TableRow>
                    );
                  })}
                </TableBody>
                {isUserNotFound && (
                  <TableBody>
                    <TableRow>
                      <TableCell align='center' colSpan={6} sx={{ py: 3 }}>
                        <SearchNotFound searchQuery={filter} />
                      </TableCell>
                    </TableRow>
                  </TableBody>
                )}
              </Table>
            </TableContainer>
          </Scrollbar>

          <MyTablePagination
            count={totalrows}
            rowsPerPage={rowsPerPage}
            page={page}
            setPage={setPage}
            setRowsPerPage={setRowsPerPage}
          />
        </Card>
      </Container>
    </Page>
  );
}
