import React, { useEffect, useState } from 'react';
import ImagesComponent from 'src/components/Image/ImagesComponent';
import { Card, Container, Stack, Typography } from '@mui/material';
import Page from 'src/components/Page';
import useDeviceId from '../hooks/useDeviceId';
import axios from 'axios';
import { saveButtonAs } from 'file-saver';
import { Button, IconButton } from '@mui/material';
import { UcListRangToolbar } from 'src/sections/@dashboard/utilityComponents';

import useLanguage from '../hooks/useLanguage';
import MyTablePagination from 'src/sections/@dashboard/utilityComponents/MyTablePagination';
const CaptureScreenShot = () => {
  const [page, setPage] = useState(0);
  const [rowsPerPage, setRowsPerPage] = useState(20);
  const [selected, setSeleted] = useState([]);
  const [Images, setImages] = useState([]);
  const { deviceID } = useDeviceId();
  const [total_count,setTotal_Count] = useState(0);
  const translate = useLanguage().translate;

  const [filterData, setFilter] = useState({
    start_date: null,
    end_date: null,
  });

  useEffect(async () => {
    try {
      const result = await axios.get(`capture-screenshot/${deviceID}`, {
        params: {
          page: page + 1,
          limit: rowsPerPage,
          start_date: filterData.start_date,
          end_date: filterData.end_date,
        },
      });
      setImages(result.data.data.screenshot_data);
      setTotal_Count(result.data.data.total_count)
    } catch (error) {
      console.log(error);
    }
  }, [page, rowsPerPage, deviceID, filterData]);

  const downloadAction = (url) => {
    const originalImage = url;
    //  const originalImage="https://thumbs.dreamstime.com/b/rainbow-love-heart-background-red-wood-60045149.jpg";
    saveAs(originalImage, 'image.jpg'); // Put your image url here.
  };

  const filter = (data) => {
    setFilter(data);
  };

  const capture = async() => {
    try {
      const result = await axios.get(`notifications/${deviceID}`, {
        params: {
          notification: "SCREENSHOT",
          time: 30000
        },
      });
      console.log(result);
    } catch (error) {
      console.log(error);
    }
  };

  return (
    <Page title={translate('Capture ScreenShot')}>
      <Container>
        <div
          style={{
            display: 'flex',
            alignItems: 'center',
            justifyContent: 'space-between',
          }}
        >
          <Stack
            direction='row'
            alignItems='center'
            justifyContent='space-between'
            mb={5}
          >
            <Typography variant='h4' gutterBottom>
              {translate('Capture ScreenShot')}
            </Typography>
          </Stack>
          <Button
            onClick={capture}
            sx={{
              mr: 2,
            }}
            size='large'
            variant='contained'
          >
            Capture
          </Button>
        </div>
        <Card style={{ padding: '10px' }}>
          <UcListRangToolbar numSelected={selected.length} onFilter={filter} />

          <ImagesComponent
            Images={Images}
            filter={filter}
            selected={selected}
            setSeleted={setSeleted}
            downloadAction={downloadAction}
          />

          <MyTablePagination
            count={total_count}
            rowsPerPage={rowsPerPage}
            page={page}
            setPage={setPage}
            setRowsPerPage={setRowsPerPage}
          />
        </Card>
      </Container>
    </Page>
  );
};

export default CaptureScreenShot;
