import { Button, Card, Container, Stack, Typography } from '@mui/material';
import React from 'react';
import Page from 'src/components/Page';
import GoogleMapReact from 'google-map-react';
import LocationOnIcon from '@mui/icons-material/LocationOn';
import useLanguage from '../hooks/useLanguage';
const CurrentLocationPage = () => {
  const translate = useLanguage().translate;
  return (
    <Page title={translate('Current Location')}>
      <Container>
        <Stack
          direction='row'
          alignItems='center'
          justifyContent='space-between'
          mb={5}
        >
          <Typography variant='h4' gutterBottom>
            {translate('Current Location')}
          </Typography>
        </Stack>
        <div style={{ textAlign: 'right', marginBottom: '15px' }}>
          <Button variant='contained' size='large'>Send Notification</Button>
        </div>
        <Card>
          <div style={{ height: '60vh', width: '100%' }}>
            <GoogleMapReact
              bootstrapURLKeys={{
                key: process.env.REACT_APP_GOOGLE_MAP_API_KEY,
              }}
              defaultCenter={{
                lat: Number('44.968046'),
                lng: Number('-94.420307'),
              }}
              defaultZoom={15}
            >
              <LocationOnIcon
                style={{
                  marginTop: '-34px',
                  marginLeft: '-17px',
                  cursor: 'pointer',
                }}
                lat={Number('44.968046')}
                lng={Number('-94.420307')}
                fontSize='large'
                color='error'
              />
            </GoogleMapReact>
          </div>
        </Card>
      </Container>
    </Page>
  );
};

export default CurrentLocationPage;
