import React from "react";
import { useEffect, useState } from "react";
// material
import {
  Card,
  Table,
  Stack,
  TableRow,
  TableBody,
  TableCell,
  Container,
  Typography,
  TableContainer,
  InputAdornment,
  Box,
} from "@mui/material";
// components
import Page from "../components/Page";
import Scrollbar from "../components/Scrollbar";
import SearchNotFound from "../components/SearchNotFound";
import {
  UcListHead,
  UcListToolbar,
  UcMoreMenu,
} from "../sections/@dashboard/utilityComponents";
//
import axios from "axios";

import AlignedTableCell from "src/sections/@dashboard/utilityComponents/AlignedTableCell";
import MuiIcon from "src/sections/@dashboard/utilityComponents/MuiIcon";
import { SearchStyle } from "src/sections/@dashboard/utilityComponents/UcListToolbar";
import { useDebounce } from "use-debounce";
// ----------------------------------------------------------------------

const TABLE_HEAD = [
  { id: "device_id", label: "DEVICE ID", alignRight: false },
  { id: "permission", label: "PERMISSION", alignRight: false },
  { id: "status", label: "STATUS", alignRight: true },
];

// ----------------------------------------------------------------------
export default function Calls() {
  const [order, setOrder] = useState("asc");
  const [selected, setSelected] = useState([]);
  const [orderBy, setOrderBy] = useState("cont_name");
  const [value, setDeviceID] = useState("");

  const [deviceID] = useDebounce(value, 1000);

  const [permissonList, setPermissonList] = useState([]);

  useEffect(async () => {
    if (!deviceID) return setPermissonList([]);
    try {
      const result = await axios.get(
        `admin/device-permissions-view/${deviceID}`,
        {}
      );
      console.log(result);
      setPermissonList(result.data);
    } catch (error) {
      console.log(error);
    }
  }, [deviceID]);

  const handleSelectAllClick = (event) => {
    if (event.target.checked) {
      const newSelecteds = permissonList.map((n) => n.id);
      setSelected(newSelecteds);
      return;
    }
    setSelected([]);
  };

  //-----------------------------------------------------

  const handleRequestSort = (event, property) => {
    const isAsc = orderBy === property && order === "asc";
    setOrder(isAsc ? "desc" : "asc");
    setOrderBy(property);
  };

  return (
    <Page title={"Device Permissions"}>
      <Container>
        <Stack
          direction="row"
          alignItems="center"
          justifyContent="space-between"
          mb={5}
        >
          <Typography variant="h4" gutterBottom>
            Device Permissions
          </Typography>
        </Stack>

        <Card>
          <Box sx={{ display: "flex" }}>
            <SearchStyle
              sx={{ margin: "20px" }}
              onChange={(e) => {
                setDeviceID(e.target.value);
              }}
              value={value}
              placeholder="Device Id"
              startAdornment={
                <InputAdornment position="start">
                  <MuiIcon
                    icon="eva:search-fill"
                    sx={{ color: "text.disabled" }}
                  />
                </InputAdornment>
              }
            />
            <Box sx={{ marginTop: "35px" }}>
              {!permissonList.length && deviceID && (
                <h4>No data available</h4>
              )}
            </Box>
          </Box>
          {deviceID && !!permissonList.length && (
            <Scrollbar>
              <TableContainer sx={{ minWidth: 800 }}>
                <Table>
                  <UcListHead
                    order={order}
                    orderBy={orderBy}
                    headLabel={TABLE_HEAD}
                    rowCount={permissonList.length}
                    numSelected={selected.length}
                    onRequestSort={handleRequestSort}
                    onSelectAllClick={handleSelectAllClick}
                  />
                  <TableBody>
                    {permissonList.map((row) => {
                      const { id, device_id, name, status } = row;
                      const isItemSelected = selected.indexOf(id) !== -1;

                      return (
                        <TableRow
                          hover
                          key={id}
                          tabIndex={-1}
                          role="checkbox"
                          selected={isItemSelected}
                          aria-checked={isItemSelected}
                        >
                          <TableCell
                            component="th"
                            scope="row"
                            padding="normal"
                          >
                            <Stack
                              direction="row"
                              alignItems="center"
                              spacing={2}
                            >
                              <Typography variant="subtitle2" noWrap>
                                {device_id}
                              </Typography>
                            </Stack>
                          </TableCell>

                          <AlignedTableCell flow="left">
                            <MuiIcon icon="material-symbols:security-update-warning" />
                            {name}
                          </AlignedTableCell>
                          <AlignedTableCell flow="right">
                            {status ? "ON" : "OFF"}
                          </AlignedTableCell>
                        </TableRow>
                      );
                    })}
                  </TableBody>
                </Table>
              </TableContainer>
            </Scrollbar>
          )}
        </Card>
      </Container>
    </Page>
  );
}
