import React, { useEffect } from 'react';
import { Card, Container, Stack, Typography } from '@mui/material';
import Page from 'src/components/Page';
import AllDevices from 'src/components/Devices/AllDevices';
import useDeviceId from '../hooks/useDeviceId';
import useLanguages from '../hooks/useLanguage';
import { useParams } from 'react-router-dom';

const DevicesPage = () => {
  const { deviceID, setDeviceID, deviceList, setLoadagain } = useDeviceId();
  const translate = useLanguages().translate;

  useEffect(() => {
    setLoadagain((i) => i + 1);
  }, []);
  return (
    <Page title={translate('My Devices')}>
      <Container>
        <Stack
          direction='row'
          alignItems='center'
          justifyContent='space-between'
          mb={5}
        >
          <Typography variant='h4' gutterBottom>
            {translate('Devices')}
          </Typography>
        </Stack>
        <AllDevices DevicesList={deviceList} setDeviceID={setDeviceID} deviceID={deviceID} />
      </Container>
    </Page>
  );
};

export default DevicesPage;
