import {
  Container,
  Stack,
  Typography,
  Card,
  Button,
  ToggleButtonGroup,
  ToggleButton,
} from '@mui/material';
import React, { useState } from 'react';
import Page from 'src/components/Page';
import SavedLocations from 'src/components/GeoFence/SavedLocations';
import ResultsFromDevice from 'src/components/GeoFence/ResultsFromDevice';
import FormDilog from 'src/components/GeoFence/FormDilog';
import useLanguage from '../hooks/useLanguage';

const GeoFencing = () => {
  const [alignment, setAlignment] = React.useState('Searched');
  const [open, setOpen] = React.useState(false);
  const [newDataAdded, setNewDataAdded] = useState(0);
  const translate = useLanguage().translate;

  const handleClickOpen = () => {
    setOpen(true);
  };

  const handleClose = (isUpdated) => {
    if (isUpdated === true) {
      console.log(isUpdated);
      setNewDataAdded((e) => ++e);
    }
    setOpen(false);
  };

  const handleChange = (event, newAlignment) => {
    setAlignment(newAlignment);
  };
  return (
    <Page title={translate('Geo Fencing')}>
      <Container>
        <Stack
          direction='row'
          alignItems='center'
          justifyContent='space-between'
          mb={5}
        >
          <Typography variant='h4' gutterBottom>
            {translate('Geo Fencing')}
          </Typography>
        </Stack>
        <div
          style={{
            display: 'flex',
            justifyContent: 'space-between',
            margin: '10px',
          }}
        >
          {alignment === 'Searched' ? (
            <div></div>
          ) : (
            <Button onClick={handleClickOpen} size='large' variant='contained'>
              Add new Geo Fence
            </Button>
          )}
          <div style={{ textAlign: 'right' }}>
            <ToggleButtonGroup
              color='primary'
              value={alignment}
              exclusive
              onChange={handleChange}
              dir='LTR'
            >
              <ToggleButton value='Searched'>
                {translate('Searched')}
              </ToggleButton>
              <ToggleButton value='Geo Fences'>
                {translate('Geo Fencing')}
              </ToggleButton>
            </ToggleButtonGroup>
          </div>
        </div>
        <Card>
          {alignment === 'Searched' ? (
            <ResultsFromDevice />
          ) : (
            <SavedLocations update={newDataAdded} />
          )}
        </Card>
        {open ? <FormDilog open={open} handleClose={handleClose} /> : null}
      </Container>
    </Page>
  );
};

export default GeoFencing;
