import {
  Card,
  Container,
  Stack,
  TablePagination,
  Typography,
} from '@mui/material';
import axios from 'axios';
import React, { useEffect, useState } from 'react';
import GmailComponent from 'src/components/Gmail/GmailComponent';
import Page from 'src/components/Page';
import { UcListToolbar } from 'src/sections/@dashboard/utilityComponents';
import MyTablePagination from 'src/sections/@dashboard/utilityComponents/MyTablePagination';

import useDeviceId from '../hooks/useDeviceId';

import useLanguage from '../hooks/useLanguage';

const GmailPage = () => {
  const [page, setPage] = useState(0);
  const [rowsPerPage, setRowsPerPage] = useState(5);
  const { deviceID, setDeviceID } = useDeviceId();
  const translate = useLanguage().translate;

  const [mails, setMails] = useState([]);
  const [totalrows, settotalrows] = useState(0);
  const [selected, setSelected] = useState([]);
  const [filter, setFilter] = useState('');

  useEffect(async () => {
    try {
      const result = await axios.get(`gmail/${deviceID}`, {
        params: {
          page: page + 1,
          limit: rowsPerPage,
          search: filter,
        },
      });
      setMails(result.data.data.gmail_data);
      settotalrows(result.data.data.total_count);
      console.log(result);
    } catch (error) {
      console.log(error);
    }
  }, [page, rowsPerPage, deviceID, filter]);

  return (
    <Page title={translate('Gmail')}>
      <Container>
        <Stack
          direction='row'
          alignItems='center'
          justifyContent='space-between'
          mb={5}
        >
          <Typography variant='h4' gutterBottom>
            {translate('Gmail')}
          </Typography>
        </Stack>

        <Card>
          <GmailComponent
            emails={mails}
            selected={selected}
            setSelected={setSelected}
            filter={filter}
            setFilter={setFilter}
          />

          <MyTablePagination
            count={totalrows}
            rowsPerPage={rowsPerPage}
            page={page}
            setPage={setPage}
            setRowsPerPage={setRowsPerPage}
          />
        </Card>
      </Container>
    </Page>
  );
};

export default GmailPage;
