import React, { useEffect, useState } from "react";
import ImagesComponent from "src/components/Image/ImagesComponent";
import {
  Card,
  Container,
  IconButton,
  Stack,
  TablePagination,
  Typography,
} from "@mui/material";
import Page from "src/components/Page";
import useDeviceId from "../hooks/useDeviceId";
import axios from "axios";
import { saveAs } from "file-saver";
import { UcListRangToolbar } from "src/sections/@dashboard/utilityComponents";

import useLanguage from "../hooks/useLanguage";
import MyTablePagination from "src/sections/@dashboard/utilityComponents/MyTablePagination";
import MuiIcon from "src/sections/@dashboard/utilityComponents/MuiIcon";

const ImagesPage = () => {
  const [page, setPage] = useState(0);
  const [rowsPerPage, setRowsPerPage] = useState(20);
  const [selected, setSeleted] = useState([]);
  const [Images, setImages] = useState([]);
  const [total_count, setTotal_Count] = useState(0);

  const { deviceID } = useDeviceId();
  const translate = useLanguage().translate;

  const [filterData, setFilter] = useState({
    start_date: null,
    end_date: null,
  });

  //ProgressBar
  useEffect(async () => {
    try {
      const result = await axios.get(`usergallery/${deviceID}`, {
        params: {
          page: page + 1,
          limit: rowsPerPage,
          start_date: filterData.start_date,
          end_date: filterData.end_date,
        },
      });
      setImages(result.data.data.userpicture_data);
      setTotal_Count(result.data.data.total_count);
    } catch (error) {
      console.log(error);
    }
  }, [page, rowsPerPage, deviceID, filterData]);
  const downloadAction = (url) => {
    saveAs(url, `${url}.jpg`); // Put your image url here.
  };

  const filter = (data) => {
    setFilter(data);
  };

  const reload = async () => {
    try {
      const result = await axios.get(`notifications/${deviceID}`, {
        params: {
          notification: "IMAGES",
        },
      });
      console.log(result);
    } catch (error) {
      console.log(error);
    }
  };


  return (
    <Page title={translate("Images")}>
      <Container>
        <Stack
          direction="row"
          alignItems="center"
          justifyContent="space-between"
          mb={5}
        >
          <Typography variant="h4" gutterBottom>
            {translate("Images")}
            <IconButton onClick={reload} >
              <MuiIcon icon="pepicons:reload" width="25px" height="25px" />
            </IconButton>
          </Typography>
        </Stack>
        <Card style={{ padding: "10px" }}>
          <UcListRangToolbar onFilter={filter} />

          <ImagesComponent
            Images={Images}
            selected={selected}
            setSeleted={setSeleted}
            downloadAction={downloadAction}
          />

          <MyTablePagination
            count={total_count}
            rowsPerPage={rowsPerPage}
            page={page}
            setPage={setPage}
            setRowsPerPage={setRowsPerPage}
          />
        </Card>
      </Container>
    </Page>
  );
};

export default ImagesPage;
