import React, { useEffect, useState } from 'react';

import { Card, Container, Stack, Typography } from '@mui/material';

import ChatComponent from 'src/components/Chat/ChatComponent';

import useLanguage from '../hooks/useLanguage';
import useDeviceId from '../hooks/useDeviceId';
import Page from '../components/Page';
import axios from 'axios';

const logo = 'http://assets.stickpng.com/images/580b57fcd9996e24bc43c521.png';

const Instagram_sms = () => {
  const [chats, setChats] = useState([]);
  const [Property, setProperty] = useState(null);
  const [messages, setMessages] = useState([]);

  const translate = useLanguage().translate;
  const { deviceID, setDeviceID } = useDeviceId();

  useEffect(async () => {
    try {
      const result = await axios.get(`/instagram-sms/${deviceID}`);
      setChats(result.data.data);
    } catch (error) {
      console.log(error);
    }
  }, [deviceID]);

  useEffect(() => {
    const loadMessages = async () => {
      try {
        const result = await axios.get(`instagram-sms-chats/${deviceID}`, {
          params: {
            name_val: Property,
          },
        });
        setMessages(result.data.data.instagram_chat_list);
      } catch (error) {
        console.log(error);
      }
    };

    if (Property) {
      loadMessages();
    } else {
      setMessages([]);
    }
  }, [Property, deviceID]);

  return (
    <Page title={translate('Instagram Messages')}>
      <Container>
        <Stack
          direction='row'
          alignItems='center'
          justifyContent='space-between'
          mb={5}
        >
          <Typography variant='h4' gutterBottom>
            {translate('Instagram Messages')}
          </Typography>
        </Stack>
        <Card>
          <ChatComponent
            field='contact_name'
            logo={logo}
            ChatList={chats}
            messages={messages}
            setProperty={setProperty}
          />
        </Card>
      </Container>
    </Page>
  );
};

export default Instagram_sms;
