import React, { useEffect, useState } from 'react';

import { Card, Container, Stack, Typography } from '@mui/material';

import ChatComponent from 'src/components/Chat/ChatComponent';

import useLanguage from '../hooks/useLanguage';
import useDeviceId from '../hooks/useDeviceId';
import Page from '../components/Page';
import axios from 'axios';

const logo =
  'https://freepngimg.com/thumb/gmail/64824-logo-sms-email-gmail-hd-image-free-png.png';

const MassagesPage = () => {
  const [chats, setChats] = useState([]);
  const [Property, setProperty] = useState(null);
  const [messages, setMessages] = useState([]);
  const translate = useLanguage().translate;

  const { deviceID  } = useDeviceId();

  useEffect(async () => {
    try {
      const result = await axios.get(`/chats/${deviceID}`);
      setChats(result.data.data);
    } catch (error) {
      console.log(error);
    }
  }, [deviceID]);

  useEffect(() => {
    const loadMessages = async () => {
      try {
        const result = await axios.get(`sms_list/${deviceID}`, {
          params: {
            number_val: Property,
          },
        });

        setMessages(result.data.data);
      } catch (error) {
        console.log(error);
      }
    };

    if (Property) {
      loadMessages();
    } else {
      setMessages([]);
    }
  }, [Property, deviceID]);

  return (
    <Page title={translate('SMS')}>
      <Container>
        <Stack
          direction='row'
          alignItems='center'
          justifyContent='space-between'
          mb={5}
        >
          <Typography variant='h4' gutterBottom>
            {translate('SMS')}
          </Typography>
        </Stack>
        <Card>
          <ChatComponent
            field='number'
            logo={logo}
            ChatList={chats}
            messages={messages}
            setProperty={setProperty}
          />
        </Card>
      </Container>
    </Page>
  );
};

export default MassagesPage;
