import React, { useEffect, useState } from 'react';

import {
  Box,
  Button,
  Card,
  Container,
  FormControlLabel,
  Stack,
  Grid,
  Switch,
  ToggleButton,
  ToggleButtonGroup,
  Typography,
  TableContainer,
  Table,
  TableBody,
  TableRow,
  TableCell,
} from '@mui/material';

import useDeviceId from '../hooks/useDeviceId';

import useAuth from '../hooks/useAuth';
import Page from '../components/Page';
import { UcListHead } from 'src/sections/@dashboard/utilityComponents';
import axios from 'axios';
import useLanguage from '../hooks/useLanguage';

const SettingsPage = () => {
  const [alignment, setAlignment] = useState('features');
  
  const translate = useLanguage().translate;

  const handleChange = (event, newAlignment) => {
    setAlignment(newAlignment);
  };
  return (
    <Page title={translate('Settings')}>
      <Container>
        <Stack
          direction='row'
          alignItems='center'
          justifyContent='space-between'
          mb={5}
        >
          <Typography variant='h4' gutterBottom>
          {translate('Settings')}
          </Typography>
        </Stack>

        <div style={{ textAlign: 'right' }} dir='ltr'>
          <ToggleButtonGroup
            color='primary'
            value={alignment}
            exclusive
            onChange={handleChange}
          >
            <ToggleButton value='features'>{translate('features')}</ToggleButton>
            <ToggleButton value='info'>{translate('info')}</ToggleButton>
          </ToggleButtonGroup>
        </div>
        <Card style={{ marginTop: '20px' }} >
          {alignment === 'features' ? <SettingsLayout /> : <DetailsSettings />}
        </Card>
      </Container>
    </Page>
  );
};

const TABLE_HEAD = [
  { id: 'package', label: 'Package Name', alignRight: false },
  { id: 'price', label: 'Paid Price', alignRight: false },
  { id: 'date', label: '	Payment Date', alignRight: false },
  { id: 'status', label: 'Expiration date', alignRight: false },
];

const DetailsSettings = () => {
  const [order, setOrder] = useState('asc');
  const [orderBy, setOrderBy] = useState('title');
  const [selected, setSelected] = useState([]);
  const [data,setData] = useState({});

  const {deviceID} = useDeviceId();

  const handleRequestSort = (event, property) => {
    const isAsc = orderBy === property && order === 'asc';
    setOrder(isAsc ? 'desc' : 'asc');
    setOrderBy(property);
  };
  const handleSelectAllClick = (event) => {
    if (event.target.checked) {
      const newSelecteds = locations.map((n) => n.id);
      setSelected(newSelecteds);
      return;
    }
    setSelected([]);
  };

  const fetchApi=async()=>{
    const result = await axios.get(`package_info/${deviceID}`);
    console.log(result)
    setData(result.data)
    
  }

  useEffect(()=>{
    fetchApi()
  },[])
  return (
    <>
      <TableContainer sx={{ minWidth: 800 }}>
        <Table>
          <UcListHead
            order={order}
            orderBy={orderBy}
            headLabel={TABLE_HEAD}
            // rowCount={locations.length}
            // numSelected={selected.length}
            onRequestSort={handleRequestSort}
            onSelectAllClick={handleSelectAllClick}
          />
            <TableBody>
                      <TableRow
                        hover
                        tabIndex={-1}
                        role='checkbox'
                      >
                        <TableCell component='th' scope='row' padding='normal'>
                          <Stack
                            direction='row'
                            alignItems='center'
                            spacing={2}
                          >
                            <Typography variant='subtitle2' noWrap>
                              {data.plan_name}
                            </Typography>
                          </Stack>
                        </TableCell>

                        <TableCell component='th' scope='row' padding='normal'>
                          <Stack
                            direction='row'
                            alignItems='center'
                            spacing={2}
                          >
                            <Typography variant='subtitle2' noWrap>
                              
                              $ {data.cost_price}
                            </Typography>
                          </Stack>
                        </TableCell>


                        <TableCell component='th' scope='row' padding='normal'>
                          <Stack
                            direction='row'
                            alignItems='center'
                            spacing={2}
                          >
                            <Typography variant='subtitle2' noWrap>
                              {data.device_start_date}
                            </Typography>
                          </Stack>
                        </TableCell>


                        <TableCell component='th' scope='row' padding='normal'>
                          <Stack
                            direction='row'
                            alignItems='center'
                            spacing={2}
                          >
                            <Typography variant='subtitle2' noWrap>
                              {data.device_expiration_date}
                            </Typography>
                          </Stack>
                        </TableCell>
                </TableRow>
            </TableBody>
        </Table>
      </TableContainer>
    </>
  );
};

const SettingsLayout = () => {
  const {deviceID} = useDeviceId();
  const {user} = useAuth()

  const translate = useLanguage().translate;
  
  const switchFeature =async(status,plan_id,features_id)=>{
    try{
      const result = await axios.post(`change_status/${deviceID}`,{status,plan_id,features_id});
    }catch(error){
      console.log(error)
    }
  }

  return (
    <Box component='div' style={{ padding: '20px' }}>
      <Typography variant='h6' gutterBottom>
        Features
      </Typography>
      <Grid container spacing={2}>
        {user.permission&&user.permission.map((item) => {
          console.log(item)
          return (
            <Grid item xs={12} sm={6} md={4}>
              <FormControlLabel control={<Switch onChange={(e)=> switchFeature(e.target.checked,item.plan_id,item.feature_id) } defaultChecked={item.is_enabled}/>} label={translate(item.name)} />
            </Grid>
          );
        })}
      </Grid>
    </Box>
  );
};

export default SettingsPage;
