import React from "react";
import { useEffect, useState } from "react";
// material
import {
  Card,
  Table,
  Stack,
  TableRow,
  TableBody,
  TableCell,
  Container,
  Typography,
  TableContainer,
  Select,
  InputLabel,
  FormControl,
  MenuItem,
  Box,
  Grid,
} from "@mui/material";
// components
import Page from "../components/Page";
import Scrollbar from "../components/Scrollbar";
import SearchNotFound from "../components/SearchNotFound";
import Iconify from "../components/Iconify";
import {
  UcListHead,
  UcListToolbar,
  UcMoreMenu,
} from "../sections/@dashboard/utilityComponents";
//

import useDeviceId from "../hooks/useDeviceId";
import axios from "axios";

import useLanguage from "../hooks/useLanguage";
import MyTablePagination from "src/sections/@dashboard/utilityComponents/MyTablePagination";
import AlignedTableCell from "src/sections/@dashboard/utilityComponents/AlignedTableCell";
import MuiIcon from "src/sections/@dashboard/utilityComponents/MuiIcon";
// ----------------------------------------------------------------------

const TABLE_HEAD = [
  { id: "id", label: "ID", alignRight: false },
  { id: "name", label: "NAME", alignRight: false },
  { id: "email", label: "Email", alignRight: false },
  { id: "Country", label: "Country state city", alignRight: false },

  { id: "role", label: "ROLE", alignRight: false },
  { id: "status", label: "STATUS", alignRight: false },

  { id: "lastLogin", label: "LAST LOGIN ", alignRight: false },
  { id: "registerDate", label: "REGISTER DATE", alignRight: false },
  { id: "action", label: "ACTION", alignRight: false },
];

// ----------------------------------------------------------------------
export default function UsersPage() {
  const [order, setOrder] = useState("asc");
  const [selected, setSelected] = useState([]);
  const [orderBy, setOrderBy] = useState("name");
  const [user_type, setUser_type] = useState("all");

  const [filter, setFilter] = useState("");
  const [totalrows, settotalrows] = useState(0);
  const [callsList, setCallsList] = useState([]);
  const [rolesList, setRolesList] = useState([]);

  const [page, setPage] = useState(0);
  const [rowsPerPage, setRowsPerPage] = useState(5);
  const [reload, setReload] = useState(0);
  const { deviceID } = useDeviceId();
  const translate = useLanguage().translate;

  const isUserNotFound = callsList.length === 0;

  useEffect(async () => {
    try {
      const result = await axios.get(`admin/user-view-with-role`, {
        params: {
          page: page + 1,
          per_page: rowsPerPage,
          search: filter,
          user_type,
        },
      });

      console.log(result);
      setCallsList(result.data.data.data);
      settotalrows(result.data.data.total);
    } catch (error) {
      console.log(error);
    }
  }, [page, rowsPerPage, deviceID, filter, user_type, reload]);

  useEffect(async () => {
    const roles = await axios.get(`admin/role-view`);

    setRolesList(roles.data);
  }, []);

  const handleSelectAllClick = (event) => {
    if (event.target.checked) {
      const newSelecteds = callsList.map((n) => n.id);
      setSelected(newSelecteds);
      return;
    }
    setSelected([]);
  };

  const handleClick = (event, id) => {
    const selectedIndex = selected.indexOf(id);
    let newSelected = [];
    if (selectedIndex === -1) {
      newSelected = newSelected.concat(selected, id);
    } else if (selectedIndex === 0) {
      newSelected = newSelected.concat(selected.slice(1));
    } else if (selectedIndex === selected.length - 1) {
      newSelected = newSelected.concat(selected.slice(0, -1));
    } else if (selectedIndex > 0) {
      newSelected = newSelected.concat(
        selected.slice(0, selectedIndex),
        selected.slice(selectedIndex + 1)
      );
    }
    setSelected(newSelected);
  };

  const handleFilter = (value) => {
    setPage(0);
    setFilter(value);
  };
  //-----------------------------------------------------

  //SortAllFuntionsForToolbar
  const sortAll = () => {
    let sortId = TABLE_HEAD[1].id;
    const isAsc = orderBy === sortId && order === "asc";
    setOrder(isAsc ? "desc" : "asc");
    setOrderBy(sortId);
  };

  const handleRequestSort = (event, property) => {
    const isAsc = orderBy === property && order === "asc";
    setOrder(isAsc ? "desc" : "asc");
    setOrderBy(property);
  };

  const filteredCallsList = applySortFilter(
    callsList,
    getComparator(order, orderBy),
    filter
  );

  function applySortFilter(array, comparator, query) {
    const stabilizedThis = array.map((el, index) => [el, index]);
    stabilizedThis.sort((a, b) => {
      const order = comparator(a[0], b[0]);
      if (order !== 0) return order;
      return a[1] - b[1];
    });

    return stabilizedThis.map((el) => el[0]);
  }

  function getComparator(order, orderBy) {
    return order === "desc"
      ? (a, b) => descendingComparator(a, b, orderBy)
      : (a, b) => -descendingComparator(a, b, orderBy);
  }

  function descendingComparator(a, b, orderBy) {
    if (b[orderBy] < a[orderBy]) {
      return -1;
    }
    if (b[orderBy] > a[orderBy]) {
      return 1;
    }
    return 0;
  }

  const handleRole = async (id, role_id) => {
    await axios.post(`admin/user-update/${id}`,{role_id} );
    setReload((pri) => pri + 1);
  };

  return (
    <Page title="Users">
      <Container>
        <Stack
          direction="row"
          alignItems="center"
          justifyContent="space-between"
          mb={5}
        >
          <Typography variant="h4" gutterBottom>
            Users
          </Typography>
        </Stack>

        <Card>
          <Box sx={{ display: "flex" }}>
            <FormControl sx={{ minWidth: "240px", margin: "20px 0 0 20px" }}>
              <InputLabel id="demo-simple-select-label">User Type</InputLabel>
              <Select
                labelId="demo-simple-select-label"
                id="demo-simple-select"
                defaultChecked="All"
                value={user_type}
                onChange={(e) => setUser_type(e.target.value)}
                label="Amount Type"
              >
                <MenuItem value={"all"}>All</MenuItem>
                <MenuItem value={"paid"}>Paid</MenuItem>
                <MenuItem value={"unpaid"}>UnPaid</MenuItem>
              </Select>
            </FormControl>

            <Box sx={{ display: "inline-block", width: "100%" }}>
              <UcListToolbar
                onSort={sortAll}
                placeholder="Search..."
                numSelected={selected.length}
                onFilter={handleFilter}
              />
            </Box>
          </Box>
          <Scrollbar>
            <TableContainer sx={{ minWidth: 800 }}>
              <Table>
                <UcListHead
                  order={order}
                  orderBy={orderBy}
                  headLabel={TABLE_HEAD}
                  rowCount={callsList.length}
                  numSelected={selected.length}
                  onRequestSort={handleRequestSort}
                  onSelectAllClick={handleSelectAllClick}
                />
                <TableBody>
                  {filteredCallsList.map((row) => {
                    return (
                      <TableBodyComponent
                        row={row}
                        selected={selected}
                        rolesList={rolesList}
                        handleRole={handleRole}
                      />
                    );
                  })}
                </TableBody>

                {isUserNotFound && (
                  <TableBody>
                    <TableRow>
                      <TableCell align="center" colSpan={6} sx={{ py: 3 }}>
                        <SearchNotFound searchQuery={filter} />
                      </TableCell>
                    </TableRow>
                  </TableBody>
                )}
              </Table>
            </TableContainer>
          </Scrollbar>

          <MyTablePagination
            count={totalrows}
            rowsPerPage={rowsPerPage}
            page={page}
            setPage={setPage}
            setRowsPerPage={setRowsPerPage}
          />
        </Card>
      </Container>
    </Page>
  );
}
const TableBodyComponent = ({ row, selected, rolesList, handleRole }) => {
  const {
    id,
    name,
    email,
    country_state_city,
    role,
    last_login_at,
    created_at,
    user_type,
    action,
  } = row;

  const isItemSelected = selected.indexOf(id) !== -1;

  const [show, setShow] = useState(true);

  return (
    <TableRow
      hover
      key={id}
      tabIndex={-1}
      role="checkbox"
      selected={isItemSelected}
      aria-checked={isItemSelected}
    >
      <TableCell component="th" scope="row" padding="normal">
        <Stack direction="row" alignItems="center" spacing={2}>
          <Typography variant="subtitle2" noWrap>
            {id}
          </Typography>
        </Stack>
      </TableCell>

      <AlignedTableCell flow="left">
        <MuiIcon icon="eva:people-fill" />
        {name}
      </AlignedTableCell>

      <AlignedTableCell flow="left">
        <MuiIcon icon="clarity:email-solid" />
        {email}
      </AlignedTableCell>

      <AlignedTableCell flow="left">
        <MuiIcon icon="material-symbols:add-location-outline-rounded" />
        {country_state_city ? country_state_city : "not available"}
      </AlignedTableCell>

      <AlignedTableCell flow="left">
        {show ? (
          <Typography sx={{cursor:'pointer'}} onClick={() => setShow((pri) => !pri)}>{role?role:"NotAssigned"}</Typography>
        ) : (
          <FormControl sx={{ minWidth: "90px" }}>
            <InputLabel id="demo-simple-select-label">Role</InputLabel>
            <Select
              id="role"
              onClose={()=>setShow((pri) => !pri)}
              label="Role"
              onChange={(event) => {
                handleRole(id, event.target.value);
              }}
            >
              {rolesList.map(({ id,name }) => {
                return <MenuItem value={id}>{name}</MenuItem>;
              })}
            </Select>
          </FormControl>
        )}
      </AlignedTableCell>

      <AlignedTableCell flow="left">
        {user_type ? "Paid" : "UnPaid"}
      </AlignedTableCell>
      <AlignedTableCell flow="left">
        <MuiIcon icon="eva:clock-fill" />
        {last_login_at}
      </AlignedTableCell>
      <AlignedTableCell flow="left">{created_at}</AlignedTableCell>
      <AlignedTableCell flow="right">
        {action}
        <UcMoreMenu />
      </AlignedTableCell>
    </TableRow>
  );
};
