import { Card, Container, Stack, Typography } from '@mui/material';
import axios from 'axios';
import React, { useEffect, useState } from 'react';
import Page from 'src/components/Page';
import Videos from 'src/components/Videos/Videos';
import useDeviceId from '../hooks/useDeviceId';

import useLanguage from '../hooks/useLanguage';

import { Button } from '@mui/material';

import Radio from '@mui/material/Radio';
import RadioGroup from '@mui/material/RadioGroup';
import FormControlLabel from '@mui/material/FormControlLabel';
import FormControl from '@mui/material/FormControl';
import FormLabel from '@mui/material/FormLabel';
import { UcListRangToolbar } from 'src/sections/@dashboard/utilityComponents';
import MyTablePagination from 'src/sections/@dashboard/utilityComponents/MyTablePagination';

const VideoRecording = () => {
  const [selected, setSeleted] = useState([]);
  const [VideosList, setVideos] = useState([]);
  const [page, setPage] = useState(0);
  const [rowsPerPage, setRowsPerPage] = useState(20);

  const [total_count, setTotalCount] = useState(20);
  const { deviceID } = useDeviceId();
  const translate = useLanguage().translate;
  const [toggle, setToggle] = useState('front');
  const [filterData, setFilter] = useState({
    start_date: null,
    end_date: null,
  });

  const filter = (value) => {
    setFilter(value);
  };

  useEffect(async () => {
    try {
      const result = await axios.get(`record-video/${deviceID}`, {
        params: {
          page: page + 1,
          limit: rowsPerPage,
          start_date: filterData.start_date,
          end_date: filterData.end_date,
        },
      });
      setVideos(result.data.data.recordvideo_data);
      setTotalCount(result.data.data.total_count)
    } catch (error) {
      console.log(error);
    }
  }, [page, rowsPerPage, deviceID, filterData]);

  //this action is for image download button.
  const downloadAction = (Id) => {
    console.log(`Download : =>${Id}`);
  };

  const startRecording = async () => {

    const result = await axios.get(`notifications/${deviceID}`, {
      params: {
        notification: 'REMOTE_VIDEO',
        backCam: toggle==="front"?false:true,
        time:30000
      },
    });
    console.log(result)
    setToggle('front');
  };  

  return (
    <Page title={translate('Video Recording')}>
      <Container>
        <div
          style={{
            display: 'flex',
            alignItems: 'center',
            justifyContent: 'space-between',
          }}
        >
          <Stack
            direction='row'
            alignItems='center'
            justifyContent='space-between'
            mb={5}
          >
            <Typography variant='h4' gutterBottom>
              {translate('Video Recording')}
            </Typography>
          </Stack>

          <div>
            {toggle ? (
              <Button
                onClick={startRecording}
                style={{ marginRight: '15px', marginTop: '5px' }}
                size='large'
                variant='contained'
              >
                Start Recording
              </Button>
            ) : null}

            <FormControl>
              <FormLabel id='demo-radio-buttons-group-label'>
                <b>Select Camera</b>
              </FormLabel>
              <RadioGroup
                onChange={(e) => {
                  setToggle(e.target.value);
                }}
                value={toggle}
                row
                aria-labelledby='demo-radio-buttons-group-label'
                name='radio-buttons-group'
              >
                <FormControlLabel
                  value='front'
                  control={<Radio />}
                  label='Front'
                />
                <FormControlLabel
                  value='back'
                  control={<Radio />}
                  label='Back'
                />
              </RadioGroup>
            </FormControl>
          </div>
        </div>
        <Card style={{ padding: '10px' }}>
          <UcListRangToolbar numSelected={selected.length} onFilter={filter} />
          <Videos
            selected={selected}
            setSeleted={setSeleted}
            VideosList={VideosList}
            filter={filter}
            downloadAction={downloadAction}
          />

          <MyTablePagination
            count={total_count}
            rowsPerPage={rowsPerPage}
            page={page}
            setPage={setPage}
            setRowsPerPage={setRowsPerPage}
          />
        </Card>
      </Container>
    </Page>
  );
};

export default VideoRecording;
