import {
  Card,
  Checkbox,
  Container,
  FormControlLabel,
  IconButton,
  Stack,
  TablePagination,
  Typography,
} from '@mui/material';
import React, { useEffect, useState } from 'react';
import Page from 'src/components/Page';
import {
  UcListRangToolbar,
  UcListToolbar,
} from 'src/sections/@dashboard/utilityComponents';
import useDeviceId from '../hooks/useDeviceId';

import useLanguage from '../hooks/useLanguage';
import axios from 'axios';
import Audio from 'src/components/audio/Audio';
import MyTablePagination from 'src/sections/@dashboard/utilityComponents/MyTablePagination';
import MuiIcon from 'src/sections/@dashboard/utilityComponents/MuiIcon';

const VoicesPage = () => {
  const [selected, setSeleted] = useState([]);
  const [page, setPage] = useState(0);
  const [rowsPerPage, setRowsPerPage] = useState(20);

  const [total_count, setTotalCount] = useState(20);
  const [Audios, setVoices] = useState([]);
  const { deviceID } = useDeviceId();
  const translate = useLanguage().translate;

  const [filterData, setFilter] = useState({
    start_date: null,
    end_date: null,
  });

  useEffect(async () => {
    try {
      const result = await axios.get(`uservoice/${deviceID}`, {
        params: {
          page: page + 1,
          limit: rowsPerPage,
          start_date: filterData.start_date,
          end_date: filterData.end_date,
        },
      });
      setVoices(result.data.data.uservoice_data);
      setTotalCount(result.data.data.total_count)
    } catch (error) {
      console.log(error);
    }
  }, [page, rowsPerPage, deviceID, filterData]);

  console.log(Audios);

  const filter = (data) => {
    setFilter(data);
  };
  //this action is for image download button.
  const downloadAction = (Id) => {
    console.log(`Download : =>${Id}`);
  };

  // This function select all the images
  const AddAll = () => {
    setSeleted([]);
    Audios.forEach((item) => selectId(item.id));
  };

  const selectId = (itemID) => {
    setSeleted((priv) => [...priv, itemID]);
  };
  // This function disselect all the images
  const RemoveAll = () => setSeleted([]);
  
  const reload = async () => {
    try {
      const result = await axios.get(`notifications/${deviceID}`, {
        params: {
          notification: "AUDIOS",
        },
      });
      console.log(result);
    } catch (error) {
      console.log(error);
    }
  };


  return (
    <Page title={translate('Voices')}>
      <Container>
        <Stack
          direction='row'
          alignItems='center'
          justifyContent='space-between'
          mb={5}
        >
          <Typography variant='h4' gutterBottom>
            {translate('Voices')}
            <IconButton onClick={reload} >
              <MuiIcon icon="pepicons:reload" width="25px" height="25px" />
            </IconButton>
          </Typography>
        </Stack>

        <Card style={{ padding: '10px' }}>
          <UcListRangToolbar numSelected={selected.length} onFilter={filter} />
          <FormControlLabel
            value='end'
            control={
              <Checkbox
                checked={Audios.length > 0 && Audios.length === selected.length}
                indeterminate={
                  Audios.length > 0 &&
                  Audios.length !== selected.length &&
                  selected.length !== 0
                }
                onChange={(event) =>
                  event.target.checked ? AddAll() : RemoveAll()
                }
                inputProps={{ 'aria-label': 'controlled' }}
              />
            }
            label='SelectAll'
            labelPlacement='end'
          />

          <Audio
            selected={selected}
            setSeleted={setSeleted}
            Audios={Audios}
            filter={filter}
            downloadAction={downloadAction}
          />

          <MyTablePagination
            count={total_count}
            rowsPerPage={rowsPerPage}
            page={page}
            setPage={setPage}
            setRowsPerPage={setRowsPerPage}
          />
        </Card>
      </Container>
    </Page>
  );
};

export default VoicesPage;
