import React from 'react';
import { useEffect, useState } from 'react';
// material
import {
  Card,
  Table,
  Stack,
  TableRow,
  TableBody,
  TableCell,
  Container,
  Typography,
  TableContainer,
} from '@mui/material';
// components
import Page from '../components/Page';
import Scrollbar from '../components/Scrollbar';
import SearchNotFound from '../components/SearchNotFound';
import {
  UcListHead,
  UcListToolbar,
  UcMoreMenu,
} from '../sections/@dashboard/utilityComponents';
//
import axios from 'axios';

import useDeviceId from '../hooks/useDeviceId';

import Iconify from 'src/components/Iconify';

import useLanguage from '../hooks/useLanguage';
import MyTablePagination from 'src/sections/@dashboard/utilityComponents/MyTablePagination';
import AlignedTableCell from 'src/sections/@dashboard/utilityComponents/AlignedTableCell';
import MuiIcon from 'src/sections/@dashboard/utilityComponents/MuiIcon';

// ----------------------------------------------------------------------

const TABLE_HEAD = [
  { id: 'id', label: 'ID', alignRight: false },
  { id: 'channel_name', label: 'CHANNEL NAME', alignRight: false },
  { id: 'video_title', label: 'VIDEO TITLE', alignRight: false },
];
const YoutubeDetail = () => {
  const [order, setOrder] = useState('asc');
  const [selected, setSelected] = useState([]);
  const [orderBy, setOrderBy] = useState('channel_name');
  const [filter, setFilter] = useState('');
  const [totalrows, settotalrows] = useState(0);
  const [youtubeDetailsList, setYoutubeDetailsList] = useState([]);

  const [page, setPage] = useState(0);
  const [rowsPerPage, setRowsPerPage] = useState(5);
  const { deviceID, setDeviceID } = useDeviceId();
  const translate = useLanguage().translate;

  const isUserNotFound = youtubeDetailsList.length === 0;

  useEffect(async () => {
    try {
      const result = await axios.get(`youtubedetail/${deviceID}`, {
        params: {
          page: page + 1,
          limit: rowsPerPage,
          search: filter,
        },
      });

      console.log(result);
      setYoutubeDetailsList(result.data.data.youtube_data);
      settotalrows(result.data.data.total_count);
    } catch (error) {
      console.log(error);
    }
  }, [page, rowsPerPage, deviceID, filter]);

  const handleSelectAllClick = (event) => {
    if (event.target.checked) {
      const newSelecteds = youtubeDetailsList.map((n) => n.id);
      setSelected(newSelecteds);
      return;
    }
    setSelected([]);
  };

  const handleClick = (event, id) => {
    const selectedIndex = selected.indexOf(id);
    let newSelected = [];
    if (selectedIndex === -1) {
      newSelected = newSelected.concat(selected, id);
    } else if (selectedIndex === 0) {
      newSelected = newSelected.concat(selected.slice(1));
    } else if (selectedIndex === selected.length - 1) {
      newSelected = newSelected.concat(selected.slice(0, -1));
    } else if (selectedIndex > 0) {
      newSelected = newSelected.concat(
        selected.slice(0, selectedIndex),
        selected.slice(selectedIndex + 1)
      );
    }
    setSelected(newSelected);
  };

  const handleFilter = (value) => {
    setPage(0);
    setFilter(value);
  };
  //--------------------------------
  //SortAllFuntionsForToolbar
  const sortAll = () => {
    let sortId = TABLE_HEAD[1].id;
    const isAsc = orderBy === sortId && order === 'asc';
    setOrder(isAsc ? 'desc' : 'asc');
    setOrderBy(sortId);
  };

  const handleRequestSort = (event, property) => {
    const isAsc = orderBy === property && order === 'asc';
    setOrder(isAsc ? 'desc' : 'asc');
    setOrderBy(property);
  };

  const filteredyoutubeDetailsList = applySortFilter(
    youtubeDetailsList,
    getComparator(order, orderBy),
    filter
  );

  function applySortFilter(array, comparator, query) {
    const stabilizedThis = array.map((el, index) => [el, index]);
    stabilizedThis.sort((a, b) => {
      const order = comparator(a[0], b[0]);
      if (order !== 0) return order;
      return a[1] - b[1];
    });

    return stabilizedThis.map((el) => el[0]);
  }

  function getComparator(order, orderBy) {
    return order === 'desc'
      ? (a, b) => descendingComparator(a, b, orderBy)
      : (a, b) => -descendingComparator(a, b, orderBy);
  }

  function descendingComparator(a, b, orderBy) {
    if (b[orderBy] < a[orderBy]) {
      return -1;
    }
    if (b[orderBy] > a[orderBy]) {
      return 1;
    }
    return 0;
  }

  return (
    <Page title={translate('Youtube Details')}>
      <Container>
        <Stack
          direction='row'
          alignItems='center'
          justifyContent='space-between'
          mb={5}
        >
          <Typography variant='h4' gutterBottom>
            {translate('Youtube Details')}
          </Typography>
        </Stack>

        <Card>
          <UcListToolbar
            onSort={sortAll}
            placeholder='Search...'
            numSelected={selected.length}
            onFilter={handleFilter}
          />

          <Scrollbar>
            <TableContainer sx={{ minWidth: 800 }}>
              <Table>
                <UcListHead
                  order={order}
                  orderBy={orderBy}
                  headLabel={TABLE_HEAD}
                  rowCount={youtubeDetailsList.length}
                  numSelected={selected.length}
                  onRequestSort={handleRequestSort}
                  onSelectAllClick={handleSelectAllClick}
                />
                <TableBody>
                  {filteredyoutubeDetailsList.map((row) => {
                    const { id, channel_name, video_title, action } = row;
                    const isItemSelected = selected.indexOf(id) !== -1;

                    return (
                      <TableRow
                        hover
                        key={id}
                        tabIndex={-1}
                        role='checkbox'
                        selected={isItemSelected}
                        aria-checked={isItemSelected}
                      >
                        <AlignedTableCell flow='left'>
                          {id}
                        </AlignedTableCell>
                        <AlignedTableCell flow='left'>
                          {channel_name}
                        </AlignedTableCell>
                        
                        <AlignedTableCell flow='left'>
                          <Typography variant='subtitle2' noWrap>
                            <MuiIcon icon='akar-icons:video' />
                            {video_title}
                          </Typography>
                        </AlignedTableCell>
                        
                      </TableRow>
                    );
                  })}
                </TableBody>
                {isUserNotFound && (
                  <TableBody>
                    <TableRow>
                      <TableCell align='center' colSpan={6} sx={{ py: 3 }}>
                        <SearchNotFound searchQuery={filter} />
                      </TableCell>
                    </TableRow>
                  </TableBody>
                )}
              </Table>
            </TableContainer>
          </Scrollbar>

          <MyTablePagination
            count={totalrows}
            rowsPerPage={rowsPerPage}
            page={page}
            setPage={setPage}
            setRowsPerPage={setRowsPerPage}
          />
        </Card>
      </Container>
    </Page>
  );
};

export default YoutubeDetail;
