// material
import { styled } from "@mui/material/styles";
import { Card, CardHeader } from "@mui/material";
// ----------------------------------------------------------------------

import React from "react";

const CHART_HEIGHT = 372;
const LEGEND_HEIGHT = 72;

const ChartWrapperStyle = styled("div")(({ theme }) => ({
  height: CHART_HEIGHT,
  marginTop: theme.spacing(3),
  "& .apexcharts-canvas svg": { height: CHART_HEIGHT },
  "& .apexcharts-canvas svg,.apexcharts-canvas foreignObject": {
    overflow: "visible",
  },
  "& .apexcharts-legend": {
    height: LEGEND_HEIGHT,
    alignContent: "center",
    position: "relative !important",
    borderTop: `solid 1px ${theme.palette.divider}`,
    top: `calc(${CHART_HEIGHT - LEGEND_HEIGHT}px) !important`,
  },
}));

// ----------------------------------------------------------------------
import GoogleMapReact from "google-map-react";
import LocationOnIcon from "@mui/icons-material/LocationOn";

export default function AppCurrentVisits({ translate, location }) {
  return (
    <Card>
      <CardHeader title={translate("Current Location")} />
      <ChartWrapperStyle>
        <GoogleMapReact
          bootstrapURLKeys={{ key: process.env.REACT_APP_GOOGLE_MAP_API_KEY }}
          defaultCenter={{
            lat: 40.42726,
            lng: -74.48384,
          }}
          // defaultCenter={{
          //   lat: Number(location.latitude),
          //   lng: Number(location.longitude),
          // }}
          defaultZoom={10}
        >
          <LocationOnIcon
            style={{ marginTop: "-34px", marginLeft: "-17px" }}
            lat={40.42726}
            lng={-74.48384}
            // lat={Number(location.latitude)}
            // lng={Number(location.longitude)}
            fontSize="large"
            color="error"
          />
        </GoogleMapReact>
      </ChartWrapperStyle>
    </Card>
  );
}
