import { merge } from "lodash";
import ReactApexChart from "react-apexcharts";
// material
import { Card, CardHeader, Box } from "@mui/material";
//
import { BaseOptionChart } from "../../../components/charts";

import React from "react";
// ----------------------------------------------------------------------

export default function AppWebsiteVisits({ translate, callLogDetail }) {
  const CHART_DATA = [
    {
      name: translate("Incoming Calls"),
      type: "area",
      data: callLogDetail.incoming,
    },
    {
      name: translate("Outgoing Calls"),
      type: "line",
      data: callLogDetail.outgoing,
    },
  ];

  const chartOptions = merge(BaseOptionChart(), {
    stroke: { width: [2, 3] },
    plotOptions: { bar: { columnWidth: "11%", borderRadius: 4 } },
    fill: { type: ["gradient", "solid"] },
    labels: callLogDetail.dates,
    xaxis: { type: "datetime" },
    legend: {
      tooltipHoverFormatter: function (val, opts) {
        return (
          val +
          " - " +
          opts.w.globals.series[opts.seriesIndex][opts.dataPointIndex] +
          ""
        );
      },
    },
    markers: {
      size: 5,
    },
    tooltip: {
      shared: true,
      intersect: false,
      y: {
        formatter: (y) => {
          if (typeof y !== "undefined") {
            return `${y.toFixed(0)} ${translate("Calls")}`;
          }
          return y;
        },
      },
    },
  });

  return (
    <Card>
      <CardHeader title={translate("Call Logs")} />
      <Box sx={{ p: 3, pb: 1 }} dir="ltr">
        <ReactApexChart
          type="bar"
          series={CHART_DATA}
          options={chartOptions}
          height={364}
        />
      </Box>
    </Card>
  );
}
