// material
import { alpha, styled } from '@mui/material/styles';
import { Card, Typography } from '@mui/material';
// utils
import React from 'react';
// component
import Iconify from '../../../components/Iconify';
import MuiIcon from '../utilityComponents/MuiIcon';

// ----------------------------------------------------------------------

const RootStyle = styled(Card)(({ theme }) => ({
  boxShadow: 'none',
  textAlign: 'center',
  padding: theme.spacing(5, 0),
  color: theme.palette.common.black,
  backgroundColor: '#C1D6FD',
  minHeight: '310px',
}));

const IconWrapperStyle = styled('div')(({ theme }) => ({
  margin: 'auto',
  display: 'flex',
  borderRadius: '50%',
  alignItems: 'center',
  width: theme.spacing(8),
  height: theme.spacing(8),
  justifyContent: 'center',
  marginBottom: theme.spacing(3),
  color: theme.palette.info.dark,
  backgroundImage: `linear-gradient(135deg, ${alpha(
    theme.palette.info.dark,
    0
  )} 0%, ${alpha(theme.palette.info.dark, 0.24)} 100%)`,
}));

// ----------------------------------------------------------------------

// const TOTAL = 1352831;

export default function Network({

  translate,
  networkCarrier,
  currentWifi,
  IMEI_Number,
}) {
  return (
    <RootStyle>
      <div style={{backgroundColor:'white',display:'inline-block',padding:'20px',borderRadius:'50px',border:'2px solid #ACC9FF'}} >
      <img src='/images/network.png'/>
      </div>
      
      
      {/* <IconWrapperStyle>
        <MuiIcon icon='carbon:network-overlay' width={24} height={24} />
      </IconWrapperStyle> */}
      
      
      {/* <Typography variant="h3">{fShortenNumber(TOTAL)}</Typography> */}
      <Typography variant='h3'>{translate('Network')}</Typography>
      <Typography variant='subtitle2' sx={{ opacity: 0.72 }}>
        {translate('Network Carrier')} : {networkCarrier}
      </Typography>
      <Typography variant='subtitle2' sx={{ opacity: 0.72 }}>
        {translate('Current WiFi')} : {currentWifi}
      </Typography>
      <Typography variant='subtitle2' sx={{ opacity: 0.72 }}>
        {translate('IMEI Number')} : {IMEI_Number}
      </Typography>
    </RootStyle>
  );
}
