import { Link as RouterLink } from 'react-router-dom';
// material
import {
  Box,
  Stack,
  Card,
  Button,
  Divider,
  Typography,
  CardHeader,
  Avatar,
} from '@mui/material';
// utils
import Scrollbar from '../../../components/Scrollbar';
import Iconify from '../../../components/Iconify';
import React from 'react';
import MuiIcon from '../utilityComponents/MuiIcon';
// ----------------------------------------------------------------------

// ----------------------------------------------------------------------

function NewsItem({ news }) {
  const { contact_name, message, date_time } = news;

  return (
    <Stack direction='row' alignItems='center' spacing={2}>
      <Avatar alt='avatar' />
      <Box sx={{ minWidth: 240, flex: 1 }}>
        <Typography variant='subtitle2' noWrap>
          {contact_name}
        </Typography>

        <Typography variant='body2' sx={{ color: 'text.secondary' }} noWrap>
          {message}
        </Typography>
      </Box>
      <Typography
        variant='caption'
        sx={{ pr: 3, flexShrink: 0, color: 'text.secondary' }}
      >
        {date_time}
        {/* {formatDistance(date_time, new Date())} */}
      </Typography>
    </Stack>
  );
}

export default function Newmessage({ translate, messages }) {
  return (
    <Card>
      <CardHeader title={translate('Last Chats')} />

      <Scrollbar>
        <Stack spacing={3} sx={{ p: 3, pr: 0 }}>
          {messages.map((news) => (
            <NewsItem key={news.id} news={news} />
          ))}
        </Stack>
      </Scrollbar>

      <Divider />

      <Box sx={{ p: 2, textAlign: 'right' }}>
        <Button
          component={RouterLink}
          to='../sms'
          size='small'
          color='inherit'
          endIcon={<MuiIcon icon='eva:arrow-ios-forward-fill' />}
        >
          {translate('View all')}
        </Button>
      </Box>
    </Card>
  );
}
