import { TablePagination } from "@mui/material";
import React from "react";

import useLanguage from "../../../hooks/useLanguage";
const MyTablePagination = ({
  count,
  rowsPerPage,
  page,
  setPage,
  setRowsPerPage,
}) => {
  const translate = useLanguage().translate;

  const handleChangeRowsPerPage = (event) => {
    setRowsPerPage(parseInt(event.target.value, 10));
    setPage(0);
  };

  const handleChangePage = (event, newPage) => {
    setPage(newPage);
  };

  return (
    <TablePagination
      dir="ltr"
      labelDisplayedRows={({ from, to, count }) => {
        return `${translate("of")} ${count} |  ${from} - ${to}`;
      }}
      labelRowsPerPage={translate("Rows per page:")}
      rowsPerPageOptions={[5, 20, 50, 100]}
      component="div"
      count={count}
      rowsPerPage={rowsPerPage}
      page={page}
      onPageChange={handleChangePage}
      onRowsPerPageChange={handleChangeRowsPerPage}
    />
  );
};

export default MyTablePagination;
