import PropTypes from 'prop-types';
// material
import { styled } from '@mui/material/styles';
import {
  Toolbar,
  Tooltip,
  IconButton,
  Typography,
  OutlinedInput,
  InputAdornment,
} from '@mui/material';
// component
import Iconify from '../../../components/Iconify';
import { useDebounce } from 'use-debounce';
import { useEffect, useState } from 'react';
import React from 'react';

import useLanguage from '../../../hooks/useLanguage';
import MuiIcon from './MuiIcon';
// ----------------------------------------------------------------------

const RootStyle = styled(Toolbar)(({ theme }) => ({
  height: 96,
  display: 'flex',
  justifyContent: 'space-between',
  padding: theme.spacing(0, 1, 0, 3),
}));

export const SearchStyle = styled(OutlinedInput)(({ theme }) => ({
  width: 240,
  transition: theme.transitions.create(['box-shadow', 'width'], {
    easing: theme.transitions.easing.easeInOut,
    duration: theme.transitions.duration.shorter,
  }),
  '&.Mui-focused': { width: 320, boxShadow: theme.customShadows.z8 },
  '& fieldset': {
    borderWidth: `1px !important`,
    borderColor: `${theme.palette.grey[500_32]} !important`,
  },
}));

// ----------------------------------------------------------------------

UcListToolbar.propTypes = {
  numSelected: PropTypes.number,
  filterAddress: PropTypes.string,
  onFilterAddress: PropTypes.func,
  onFilterName: PropTypes.func,
};

export default function UcListToolbar({
  numSelected,
  onSort,
  onFilter,
  placeholder,
}) {
  const translate = useLanguage().translate;
  const [text, setText] = useState('');
  const [value] = useDebounce(text, 1000);

  useEffect(() => {
    onFilter(value);
  }, [value]);

  return (
    <RootStyle
      sx={{
        ...(numSelected > 0 && {
          color: 'primary.main',
          bgcolor: 'primary.lighter',
        }),
      }}
    >
      {numSelected > 0 ? (
        <Typography component='div' variant='subtitle1'>
          {numSelected} {translate('selected')}
        </Typography>
      ) : (
        <SearchStyle
          onChange={(e) => {
            setText(e.target.value);
          }}
          value={text}
          placeholder={translate(placeholder)}
          startAdornment={
            <InputAdornment position='start'>
              <MuiIcon icon='eva:search-fill' sx={{ color: 'text.disabled' }} />
            </InputAdornment>
          }
        />
      )}

      {numSelected > 0 ? (
        <Tooltip title='Delete'>
          <IconButton>
            <MuiIcon icon='eva:trash-2-fill' />
          </IconButton>
        </Tooltip>
      ) : (
        <Tooltip title='Filter list'>
          <IconButton onClick={onSort}>
            <MuiIcon icon='ic:round-filter-list' />
          </IconButton>
        </Tooltip>
      )}
    </RootStyle>
  );
}
